/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class LevelSelectScreen
extends MenuBackgroundScreen {
    private Screen m_next;
    private String[] m_items = new String[]{"Play", "Back"};
    private int m_sel_level;
    private int m_menu_sel;
    private int m_last_open_level;

    public LevelSelectScreen(int start_level) {
        this.m_sel_level = start_level;
        this.m_last_open_level = this.getLastOpenLevel();
        Res.audio.playMusic(Res.audio.music_menu);
        if (this.m_sel_level > this.m_last_open_level) {
            this.m_sel_level = this.m_last_open_level;
        }
        if (this.m_sel_level == this.m_last_open_level - 1 && Res.hiscores.getScore(this.m_last_open_level) < 0) {
            this.m_sel_level = this.m_last_open_level;
        }
    }

    public Screen updateFrame(int fp_secs) {
        if (Res.manifest.entries.length == 0) {
            return new MainMenuScreen();
        }
        if (this.m_next != null) {
            return this.m_next;
        }
        return null;
    }

    public void render(Graphics g, int w, int h) {
        String cur_score_str;
        super.render(g, w, h);
        Font f = Font.getFont((int)32, (int)1, (int)0);
        g.setFont(f);
        int text_h = f.getHeight();
        int entry_count = Res.manifest.entries.length;
        if (this.m_sel_level >= entry_count) {
            return;
        }
        Manifest.Entry entry = Res.manifest.entries[this.m_sel_level];
        int y = 5;
        g.setColor(-5263441);
        MiscUtils.writeShadowed(g, "#" + (this.m_sel_level + 1) + " / " + (this.m_last_open_level + 1) + "  (total: " + entry_count + ")", 5, y);
        y += text_h;
        int cur_score = Res.hiscores.getScore(this.m_sel_level);
        String string = cur_score_str = cur_score < 0 ? "none" : MiscUtils.timeToString(cur_score);
        if (cur_score < 0) {
            cur_score = FP.toFP(9999);
        }
        g.setColor(-5247057);
        MiscUtils.writeCentered(g, entry.name, y, w);
        int col_yes = -96;
        int col_no = -5263504;
        g.setColor(cur_score <= entry.time_bronze ? col_yes : col_no);
        MiscUtils.writeCentered(g, "Bronze: " + MiscUtils.timeToString(entry.time_bronze), y += text_h * 2, w);
        g.setColor(cur_score <= entry.time_silver ? col_yes : col_no);
        MiscUtils.writeCentered(g, "Silver: " + MiscUtils.timeToString(entry.time_silver), y += text_h, w);
        g.setColor(cur_score <= entry.time_gold ? col_yes : col_no);
        MiscUtils.writeCentered(g, "Gold: " + MiscUtils.timeToString(entry.time_gold), y += text_h, w);
        g.setColor(-6250241);
        MiscUtils.writeCentered(g, "Current: " + cur_score_str, y += text_h * 2, w);
        y += text_h;
        y += text_h;
        if (this.m_last_open_level > 0) {
            int side_text_y = y + text_h / 2;
            g.setColor(-1);
            MiscUtils.writeCentered(g, "<<             >>", side_text_y, w);
        }
        int i = 0;
        while (i < this.m_items.length) {
            if (i == this.m_menu_sel) {
                g.setColor(-1);
            } else {
                g.setColor(-7829368);
            }
            MiscUtils.writeCentered(g, this.m_items[i], y, w);
            y += text_h;
            ++i;
        }
    }

    public void keyPressed(int key, int game_key) {
        if (game_key == 8) {
            switch (this.m_menu_sel) {
                case 0: {
                    this.m_next = new GameScreen(Res.manifest.entries[this.m_sel_level].res_name, this.m_sel_level);
                    break;
                }
                case 1: {
                    this.m_next = new MainMenuScreen();
                }
            }
            return;
        }
        if (game_key == 1) {
            --this.m_menu_sel;
            if (this.m_menu_sel < 0) {
                this.m_menu_sel = this.m_items.length - 1;
            }
        }
        if (game_key == 6) {
            ++this.m_menu_sel;
            if (this.m_menu_sel >= this.m_items.length) {
                this.m_menu_sel = 0;
            }
        }
        if (game_key == 2) {
            --this.m_sel_level;
            if (this.m_sel_level < 0) {
                this.m_sel_level = this.m_last_open_level;
            }
        }
        if (game_key == 5) {
            ++this.m_sel_level;
            if (this.m_sel_level > this.m_last_open_level) {
                this.m_sel_level = 0;
            }
        }
    }

    private int getLastOpenLevel() {
        if (Res.manifest.entries.length <= 0) {
            return 0;
        }
        if (Res.hiscores.all_levels_unlocked) {
            return Res.manifest.entries.length - 1;
        }
        int i = 0;
        while (i < Res.manifest.entries.length) {
            int bronze_time = Res.manifest.entries[i].time_bronze;
            int cur_time = Res.hiscores.getScore(i);
            if (cur_time < 0 || cur_time > bronze_time) {
                return i;
            }
            ++i;
        }
        return Res.manifest.entries.length - 1;
    }
}

