using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace StarifficEditor
{
    public partial class LevelPropertiesForm : Form
    {
        private Level m_level;
        private LevelOptions m_options;

        public LevelPropertiesForm()
        {
            InitializeComponent();
        }

        public LevelPropertiesForm(Level level) : this()
        {
            m_level = level;
            m_options = (LevelOptions) m_level.options.Clone();

            propertyGrid.SelectedObject = m_options;
        }

        private void buttonOk_Click(object sender, EventArgs e)
        {
            m_level.options = m_options;
            m_level.NotifyChanges();
            Close();
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}