////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// NOTE: This file is automatically generated from the J2ME java sources!
///

package StarifficEditorGame;

import javax.microedition.lcdui.Graphics;

/**
 * One mesh.
 */
public class Mesh
{
    public int id;
    public String name;
    
    /** (x,y) pairs. */
    public int[] point_data;
    /** Memory for temporary points. */
    public int[] point_temp;
    
    /** (color,p1,p2,p3) quads. */
    public int[] face_data;
    
    public Mesh()
    {
    }
    
    /**
     * Returns the unscaled bounding box.
     * 
     * @return Returns the unscaled bounding box.
     */
    public BoundingBox getBounds()
    {
        BoundingBox bbox = new BoundingBox();
        
        int pts = point_data.length / 2;
        int idx = 0;
        while ( pts-- > 0 )
        {
            int x = point_data[ idx++ ];
            int y = point_data[ idx++ ];
            
            if ( idx == 2 )
            { // First
                bbox.x1 = bbox.x2 = x;
                bbox.y1 = bbox.y2 = y;
            }
            else
            {
                if ( x < bbox.x1 ) bbox.x1 = x;
                if ( x > bbox.x2 ) bbox.x2 = x;
                if ( y < bbox.y1 ) bbox.y1 = y;
                if ( y > bbox.y2 ) bbox.y2 = y;
            }
        }
        
        return bbox;
    }
    
    /**
     * Renders the level object.
     */
    public int[] render( Graphics g, int mesh_scale, int angle_rad, int move_x, int move_y, int scale_x, int scale_y, int[] cache )
    {
        // Test if we need to build the cache
        boolean build_cache = false;
        if ( cache == null || cache.length != (point_data.length+4) )
            build_cache = true;
        if ( !build_cache )
        {
            int i = cache.length - 4;
            if ( cache[i] != mesh_scale ||
                 cache[i+1] != angle_rad ||
                 cache[i+2] != scale_x ||
                 cache[i+3] != scale_y )
            {
                build_cache = true;
            }
        }
        
        // Build the cache
        if (build_cache)
        {
            // Allocate
            if ( cache == null || cache.length != (point_data.length+4) )
                cache = new int[ point_data.length + 4 ];
            
            // Preconvert
            int c = FP.cos(angle_rad);
            int s = FP.sin(angle_rad);
            
            int pts = point_data.length / 2;
            int idx = 0;
            for (int i = 0; i < pts; ++i)
            {
                int x = FP.mul(point_data[ idx ], mesh_scale);
                int y = FP.mul(point_data[ idx + 1 ], mesh_scale);
                
                cache[ idx++ ] = FP.mul( FP.mul(x,c) - FP.mul(y,s), scale_x );
                cache[ idx++ ] = FP.mul( FP.mul(x,s) + FP.mul(y,c), scale_y );
            }
            
            cache[ idx++ ] = mesh_scale;
            cache[ idx++ ] = angle_rad;
            cache[ idx++ ] = scale_x;
            cache[ idx++ ] = scale_y;
        }
        
        // Convert the points
        int scaled_move_x = FP.mul( move_x, scale_x );
        int scaled_move_y = FP.mul( move_y, scale_y );
        
        int pts = point_data.length / 2;
        int idx = 0;
        for (int i = 0; i < pts; ++i)
        {
            point_temp[ idx ] = (cache[ idx ] + scaled_move_x) >> 16;
            ++idx;
            
            point_temp[ idx ] = (cache[ idx ] + scaled_move_y) >> 16;
            ++idx;
        }
        
        // Draw the faces
        int cur_col = g.getColor();
        
        int faces = face_data.length / 4;
        idx = 0;
        for (int i = 0; i < faces; ++i)
        {
            int col = face_data[ idx++ ];
            int pt1 = face_data[ idx++ ] * 2;
            int pt2 = face_data[ idx++ ] * 2;
            int pt3 = face_data[ idx++ ] * 2;
            
            if (col != cur_col)
            {
                g.setColor( col );
                cur_col = col;
            }
            
            g.fillTriangle(
                    point_temp[pt1], point_temp[pt1+1],
                    point_temp[pt2], point_temp[pt2+1],
                    point_temp[pt3], point_temp[pt3+1] );
        }
        
        return cache;
    }
}
