////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// NOTE: This file is automatically generated from the J2ME java sources!
///

package StarifficEditorGame;

import javax.microedition.lcdui.*;

public abstract class MenuBackgroundScreen extends Screen
{
    private Mesh m_mesh;
    private int[] m_mesh_cache;
    
    private int m_aspect = FP.ONE;
    private int m_width = FP.ONE;
    private int m_height = FP.ONE;
    private int m_center_x, m_center_y;
    
    public MenuBackgroundScreen()
    {
        m_mesh = Res.meshes.find( "menu01" );
        if ( m_mesh == null )
            return;
        
        BoundingBox bbox = m_mesh.getBounds();
        m_width = bbox.x2 - bbox.x1;
        m_height = bbox.y2 - bbox.y1;
        m_aspect = FP.div( m_width, m_height );
        m_center_x = (bbox.x1 + bbox.x2) / 2;
        m_center_y = (bbox.y1 + bbox.y1) / 2;
    }
    
    /**
     * Renders the current state to the given graphics.
     * 
     * @param g The destination graphics.
     * @param w The screen width.
     * @param h The screen height.
     */
    public void render( Graphics g, int w, int h )
    {
//      g.setColor( 0xff535d64 );
        g.setColor( 0xff434d54 );
        g.fillRect( 0, 0, w, h );
        
        if ( m_mesh == null )
            return;
        
        // Get the scale factors
        int aspect = FP.toFP(w) / h;
        int scale_x = 0;
        int scale_y = 0;
        int vis_w = m_width;
        int vis_h = m_height;
        if (aspect <= m_aspect)
        { // The screen is bigger in y
            scale_x = scale_y = FP.div( FP.toFP(w), m_width );
            vis_h = FP.mul( vis_h, FP.div( m_aspect, aspect ) );
        }
        else
        { // The screen is bigger in x
            scale_x = scale_y = FP.div( FP.toFP(h), m_height );
            vis_w = FP.mul( vis_w, FP.div( aspect, m_aspect ) );
        }

        int top_x = m_center_x - (vis_w>>1);
        int top_y = m_center_y - (vis_h>>1);
        
        // Draw the mesh
        m_mesh_cache = m_mesh.render( g, FP.ONE, 0, -top_x, -top_y, scale_x, scale_y, m_mesh_cache );
        
        // Write the title text
        g.setColor( 0xff434d54 );
//        g.setColor( 0xff333d44 );
        g.setFont( Font.getFont( Font.FACE_PROPORTIONAL, Font.STYLE_BOLD, Font.SIZE_LARGE ) );
        MiscUtils.writeCentered( g, "S T A R I F F I C", h / 8, w );
        
        // Write the version
        g.setColor( 0xff434d54 );
        Font f = Font.getFont( Font.FACE_PROPORTIONAL, Font.STYLE_BOLD, Font.SIZE_SMALL );
        g.setFont( f );
        MiscUtils.writeShadowed( g, Res.version, 2, h - 2 - f.getHeight() );
    }
}
