////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// NOTE: This file is automatically generated from the J2ME java sources!
///

package StarifficEditorGame;

import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

/** 
 */
public class Main extends MIDlet implements Runnable
{
    private boolean m_initialized = false;
    
    private boolean m_running;
    private int m_run_id;
    
    public static final int FPS = 30;
    public static final int MS_PER_FRAME = 1000 / FPS;
    public static final int FIXED_PER_FRAME = FP.ONE / FPS;
    
    protected void startApp() throws MIDletStateChangeException
    {
        init();
        
        // Start the running thread
        waitToStop();
        m_running = true;
        new Thread( this ).start();
    }

    protected void pauseApp()
    {
        waitToStop();
    }

    protected void destroyApp( boolean unconditional ) throws MIDletStateChangeException
    {
        waitToStop();
    }
    
    public void run()
    {
        int my_id = m_run_id;
        
        try
        {
            long last_time = System.currentTimeMillis();
            
	        while ( m_running && m_run_id == my_id )
	        {
	            long cur_time = System.currentTimeMillis();
	            int elapsed = (int) (cur_time-last_time);
	            
	            if ( elapsed < 0 || elapsed > 500 )
	            { // Time skip!
	                last_time = cur_time;
	                continue;
	            }
	            
	            int frames = elapsed / MS_PER_FRAME;
	            if ( frames <= 0 )
	            {
	                Thread.yield();
	                continue;
	            }
	            
	            // Update the frames
                last_time += MS_PER_FRAME * frames;
                
                if ( frames > 1 )
                    System.out.println("Skipped frames: " + frames);
                
	            while ( frames-- > 0 )
	            {
	                Displayable d = Res.display.getCurrent();
	                if ( d != null && (d instanceof ScreenCanvas) )
	                    ((ScreenCanvas) d).updateFrame( FIXED_PER_FRAME );
	            }
	            
	            // Draw it
                Displayable d = Res.display.getCurrent();
                if ( d != null && (d instanceof Canvas) )
                {
	            	((Canvas) d).repaint();
	            	((Canvas) d).serviceRepaints();
                }
	        }
        }
        catch ( Throwable t )
        {
            System.err.println( "EXCEPTION IN UPDATE THREAD:" );
            t.printStackTrace();
        }
        finally
        {
            m_running = false;
        }
    }
    
    /**
     * Initializes the runtime and game.
     */
    private void init()
    {
        if ( m_initialized )
            return;
        m_initialized = true;
        
        Res.midlet = this;
        Res.display = Display.getDisplay( this );
        
        Res.init();
        
        Res.display.setCurrent( new ScreenCanvas() );
    }
    
    private void waitToStop()
    {
        // Stop musics etc
        Res.audio.playMusic( null );
        
        // Wait to stop
        ++m_run_id;
        while ( m_running )
            Thread.yield();
    }
}
