////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// NOTE: This file is automatically generated from the J2ME java sources!
///

package StarifficEditorGame;

import java.io.*;

import javax.microedition.lcdui.*;

public class Goal extends LevelObject implements Collidable
{
    private static final int RADIUS = FP.toFP(0.9f);
    private static final int HIT_RADIUS = 2*RADIUS/4;
    private static final int HIT_RADIUS2 = FP.mul( HIT_RADIUS, HIT_RADIUS );
    
    public int pos_x, pos_y;
    private int mul;
    
    /**
     * Updates the level object.
     * 
     * @param time_secs
     */
    public void update( int time_secs )
    {
        mul += time_secs*4/2;
        while (mul > FP.ONE)
            mul -= FP.ONE;
    }

    /**
     * Renders the level object.
     */
    public void render( Graphics g, int top_x, int top_y, int scale_x, int scale_y )
    {
        if ( level.star.is_at_home )
            return;
        
        int radius = FP.mul( RADIUS, mul );
        int size = FP.toInt( FP.mul(scale_x, radius) * 2 );
        
        int cx = FP.toInt( FP.mul(pos_x - radius - top_x, scale_x) );
        int cy = FP.toInt( FP.mul(pos_y - radius - top_y, scale_y) );
        
        if ( level.collectibles_left > 0 )
            g.setColor( 0xff666655 );
        else
            g.setColor( 0xff90ee60 );
        g.fillArc( cx, cy, size, size, 0, 360 );
        
        // Black interior
        g.setColor( 0xff000000 );
        int radius_b = (radius*6) / 7;
        int size_b = FP.toInt( FP.mul(scale_x, radius_b) * 2 );
        int dist = size - size_b;
        
        g.fillArc( cx + dist, cy + dist, size - dist*2, size - dist*2, 0, 360 );
    }
    
    /**
     * Loads the object from the stream.
     * 
     * @param in The data stream.
     * @throws IOException
     */
    public void load(DataInputStream in) throws IOException
    {
        // Read the position
        pos_x = in.readInt();
        pos_y = in.readInt();
    }

    /**
     * Resolves a possible verlet collision.
     * 
     * @param v The verlet.
     */
    public void resolveCollision( Verlet v )
    {
        if ( level.star.is_at_home )
            return;
        if ( level.collectibles_left > 0 )
            return;
        
        // BBox test
        int dx = v.pos[0] - pos_x;
        int dy = v.pos[1] - pos_y;
        if (Math.abs(dx) >= HIT_RADIUS || Math.abs(dy) >= HIT_RADIUS)
            return;
        
        // Distance test
        int dist2 = FP.mul( dx, dx ) + FP.mul( dy, dy );
        if (dist2 >= HIT_RADIUS2)
            return;
        
        level.star.completed();
    }
}
