/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class Goal
extends LevelObject
implements Collidable {
    private static final int RADIUS = FP.toFP(0.9f);
    private static final int HIT_RADIUS = 2 * RADIUS / 4;
    private static final int HIT_RADIUS2 = FP.mul(HIT_RADIUS, HIT_RADIUS);
    public int pos_x;
    public int pos_y;
    private int mul;

    public void update(int time_secs) {
        this.mul += time_secs * 4 / 2;
        while (this.mul > 65536) {
            this.mul -= 65536;
        }
    }

    public void render(Graphics g, int top_x, int top_y, int scale_x, int scale_y) {
        if (this.level.star.is_at_home) {
            return;
        }
        int radius = FP.mul(RADIUS, this.mul);
        int size = FP.toInt(FP.mul(scale_x, radius) * 2);
        int cx = FP.toInt(FP.mul(this.pos_x - radius - top_x, scale_x));
        int cy = FP.toInt(FP.mul(this.pos_y - radius - top_y, scale_y));
        if (this.level.collectibles_left > 0) {
            g.setColor(-10066347);
        } else {
            g.setColor(-7279008);
        }
        g.fillArc(cx, cy, size, size, 0, 360);
        g.setColor(-16777216);
        int radius_b = radius * 6 / 7;
        int size_b = FP.toInt(FP.mul(scale_x, radius_b) * 2);
        int dist = size - size_b;
        g.fillArc(cx + dist, cy + dist, size - dist * 2, size - dist * 2, 0, 360);
    }

    public void load(DataInputStream in) throws IOException {
        this.pos_x = in.readInt();
        this.pos_y = in.readInt();
    }

    public void resolveCollision(Verlet v) {
        if (this.level.star.is_at_home) {
            return;
        }
        if (this.level.collectibles_left > 0) {
            return;
        }
        int dx = v.pos[0] - this.pos_x;
        int dy = v.pos[1] - this.pos_y;
        if (Math.abs(dx) >= HIT_RADIUS || Math.abs(dy) >= HIT_RADIUS) {
            return;
        }
        int dist2 = FP.mul(dx, dx) + FP.mul(dy, dy);
        if (dist2 >= HIT_RADIUS2) {
            return;
        }
        this.level.star.completed();
    }
}

