/*
 * Decompiled with CFR 0.152.
 */
package utils;

import cellrace.Point;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import utils.FixedMath;
import utils.MathExtension;

public class Draw {
    static int[] rgbGrass;
    static int[] rgbRoad;
    static int[] rgb;

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2, int stroke) {
        if (stroke == 1) {
            g.drawLine(x1, y1, x2, y2);
        } else {
            g.fillTriangle(x1, y1 + stroke, x1 + stroke, y1, x2, y2 + stroke);
            g.fillTriangle(x1 + stroke, y1, x1, y1 - stroke, x2 + stroke, y2);
            g.fillTriangle(x1, y1 - stroke, x1 - stroke, y1, x2, y2 - stroke);
            g.fillTriangle(x1 - stroke, y1, x1, y1 + stroke, x2 - stroke, y2);
            g.fillTriangle(x2, y2 + stroke, x2 + stroke, y2, x1 + stroke, y1);
            g.fillTriangle(x2 + stroke, y2, x2, y2 - stroke, x1, y1 - stroke);
            g.fillTriangle(x2, y2 - stroke, x2 - stroke, y2, x1 - stroke, y1);
            g.fillTriangle(x2 - stroke, y2, x2, y2 + stroke, x1, y1 + stroke);
        }
    }

    public static void drawBound(int[] rgb, int width, int heigth, int color) {
        int heigthminusone = heigth - 1;
        int widthminusone = width - 1;
        int x1 = 0;
        while (x1 < width) {
            rgb[x1] = color;
            rgb[width * heigthminusone + x1] = color;
            ++x1;
        }
        int y1 = 0;
        while (y1 < heigth) {
            rgb[y1 * width] = color;
            rgb[y1 * width + widthminusone] = color;
            ++y1;
        }
    }

    public static Image applyTexture(Image image, Image grass, Image road) {
        int width = image.getWidth();
        int heigth = image.getHeight();
        int roadWidth = road.getWidth();
        int roadHeigth = road.getHeight();
        int grassWidth = grass.getWidth();
        int grassHeigth = grass.getHeight();
        if (grassWidth != roadWidth || grassHeigth != roadHeigth) {
            throw new RuntimeException("Road pattern and grass pattern do not have the same size, cannot optimize");
        }
        if (rgbGrass == null) {
            rgbGrass = new int[grassWidth * grassHeigth];
            grass.getRGB(rgbGrass, 0, grassWidth, 0, 0, grassWidth, grassHeigth);
        }
        if (rgbRoad == null) {
            rgbRoad = new int[roadWidth * roadHeigth];
            road.getRGB(rgbRoad, 0, roadWidth, 0, 0, roadWidth, roadHeigth);
        }
        if (rgb == null || rgb.length != width * heigth) {
            rgb = new int[width * heigth];
        }
        image.getRGB(rgb, 0, width, 0, 0, width, heigth);
        int y = 0;
        while (y < heigth) {
            int tmpGrassy = y % grassHeigth * grassWidth;
            int tmpIndex = y * width;
            int length = width + tmpIndex;
            int x = tmpIndex;
            while (x < length) {
                if (rgb[x] == -1) {
                    Draw.rgb[x] = rgbGrass[tmpGrassy + x % grassWidth];
                } else if (rgb[x] == -16777216) {
                    Draw.rgb[x] = rgbRoad[tmpGrassy + x % grassWidth];
                }
                ++x;
            }
            ++y;
        }
        return Image.createRGBImage((int[])rgb, (int)width, (int)heigth, (boolean)false);
    }

    public static Image adaptColor(Image image, int fontColor) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] rgb = new int[width * height];
        int y = 0;
        while (y < height) {
            int[] orig = new int[width];
            image.getRGB(orig, 0, width, 0, y, width, 1);
            int tmpy = y * width;
            int x = 0;
            while (x < width) {
                rgb[tmpy + x] = (orig[x] & 0xFF000000) + (fontColor & 0xFFFFFF);
                ++x;
            }
            ++y;
        }
        return Image.createRGBImage((int[])rgb, (int)width, (int)height, (boolean)true);
    }

    public static void drawRGBImage(int[] src, int srcWidth, int srcHeight, int[] img, int x, int y, int width, int heigth) {
        int j = 0;
        while (j < heigth) {
            int i = 0;
            while (i < width) {
                int pSrc = src[(j + y) * srcWidth + i + x];
                int pImg = img[j * width + i];
                int alphaSrc = (pSrc & 0xFF000000) >>> 24;
                int redSrc = (pSrc & 0xFF0000) >>> 16;
                int greenSrc = (pSrc & 0xFF00) >>> 8;
                int blueSrc = pSrc & 0xFF;
                int alphaImg = (pImg & 0xFF000000) >>> 24;
                int redImg = (pImg & 0xFF0000) >>> 16;
                int greenImg = (pImg & 0xFF00) >>> 8;
                int blueImg = pImg & 0xFF;
                int newAlpha = alphaSrc + alphaImg;
                if (newAlpha > 255) {
                    newAlpha = 255;
                }
                if (newAlpha == 0) {
                    src[(j + y) * srcWidth + i + x] = pSrc;
                } else {
                    int newBlue;
                    int newGreen;
                    int newRed = redSrc * alphaSrc / newAlpha + redImg * alphaImg / newAlpha;
                    if (newRed > 255) {
                        newRed = 255;
                    }
                    if ((newGreen = greenSrc * alphaSrc / newAlpha + greenImg * alphaImg / newAlpha) > 255) {
                        newGreen = 255;
                    }
                    if ((newBlue = blueSrc * alphaSrc / newAlpha + blueImg * alphaImg / newAlpha) > 255) {
                        newBlue = 255;
                    }
                    src[(j + y) * srcWidth + i + x] = (newAlpha << 24) + (newRed << 16) + (newGreen << 8) + newBlue;
                }
                ++i;
            }
            ++j;
        }
    }

    public static Image rotate(Image image, Point rotateAround, int angle) {
        int origWidth = image.getWidth();
        int origHeigth = image.getHeight();
        int[] orig = new int[origWidth * origHeigth];
        image.getRGB(orig, 0, origWidth, 0, 0, origWidth, origHeigth);
        Point p1 = new Point(0, 0);
        Point p2 = new Point(0, origHeigth);
        Point p3 = new Point(origWidth, origHeigth);
        Point p4 = new Point(origWidth, 0);
        Draw.rotatePoint(p1, angle);
        Draw.rotatePoint(p2, angle);
        Draw.rotatePoint(p3, angle);
        Draw.rotatePoint(p4, angle);
        int maxx = MathExtension.max(p1.getX(), p2.getX(), p3.getX(), p4.getX());
        int maxy = MathExtension.max(p1.getY(), p2.getY(), p3.getY(), p4.getY());
        int minx = MathExtension.min(p1.getX(), p2.getX(), p3.getX(), p4.getX());
        int miny = MathExtension.min(p1.getY(), p2.getY(), p3.getY(), p4.getY());
        int max_x = Math.abs(maxx - minx);
        int max_y = Math.abs(maxy - miny);
        int[] rgb = new int[max_x * max_y];
        int cosT = FixedMath.cosArray[angle];
        int sinT = FixedMath.sinArray[angle];
        int x1 = minx < 0 ? -minx : 0;
        int y1 = miny < 0 ? -miny : 0;
        int y = 0;
        while (y < max_y) {
            int xs = -x1 * cosT + (y - y1) * sinT;
            int ys = (y - y1) * cosT - -x1 * sinT;
            int tmp = y * max_x;
            int x = 0;
            while (x < max_x) {
                int tmpx = FixedMath.roundFix(xs);
                int tmpy = FixedMath.roundFix(ys);
                if (tmpx >= 0 && tmpy >= 0 && tmpx < origWidth && tmpy < origHeigth) {
                    rgb[tmp + x] = orig[tmpy * origWidth + tmpx];
                }
                xs += cosT;
                ys -= sinT;
                ++x;
            }
            ++y;
        }
        Draw.rotatePoint(rotateAround, angle);
        rotateAround.setX(minx - rotateAround.getX());
        rotateAround.setY(miny - rotateAround.getY());
        return Image.createRGBImage((int[])rgb, (int)max_x, (int)max_y, (boolean)true);
    }

    public static void rotatePoint(Point point, int angle) {
        int cosT = FixedMath.cosArray[angle];
        int sinT = FixedMath.sinArray[angle];
        int xs = FixedMath.roundFix(point.getX() * cosT - point.getY() * sinT);
        int ys = FixedMath.roundFix(point.getY() * cosT + point.getX() * sinT);
        point.setX(xs);
        point.setY(ys);
    }

    public static void test(int i, int x) {
        if (i != x) {
            throw new RuntimeException("expected " + i + " but got " + x);
        }
    }
}

