/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

import cellrace.Point;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;
import utils.Cache;
import utils.Draw;
import utils.FixedMath;

public final class Utils {
    public static final String THUMB_PREFIX = "_thumb";
    public static final String BACKGROUND_PREFIX = "background";
    public static final String CHOICE_PREFIX = "choice";
    public static final String CHOICE_NAME = "choices";
    public static final int BOUND_COLOR = -8351696;
    public static final int BOUND_COLOR_SELECTED = -13606752;
    private static final int CHOICE_INSETS = 2;
    public static int charSize = 33;
    public static final int CHARACTER_INSETS = 2;

    public static Image createThumbnail(String prefix, String name, int per256) {
        return Utils.createThumbnail(prefix, name, per256, true);
    }

    public static Image createThumbnail(String prefix, String name, int per256, boolean cache) {
        Image image = Utils.createImage(prefix, name, true);
        return Utils.createThumbnail(prefix, name, FixedMath.roundFix(image.getWidth() * per256), FixedMath.roundFix(image.getHeight() * per256), cache);
    }

    public static Image createThumbnail(String prefix, String name, int thumbWidth, int thumbHeight) {
        return Utils.createThumbnail(prefix, name, thumbWidth, thumbHeight, true);
    }

    public static Image createThumbnail(String prefix, String name, int thumbWidth, int thumbHeight, boolean cache) {
        Image image = null;
        String thumbName = name.concat(THUMB_PREFIX);
        if (!Cache.contains(prefix, thumbName)) {
            image = Utils.createImage(prefix, name, false);
            int sourceWidth = image.getWidth();
            int sourceHeight = image.getHeight();
            if (thumbHeight < 0) {
                thumbHeight = thumbWidth * sourceHeight / sourceWidth;
            }
            if (thumbWidth < 0) {
                thumbWidth = thumbHeight * sourceWidth / sourceHeight;
            }
            System.err.println("slow operation orig w=" + sourceWidth + " h=" + sourceHeight + " thumb w=" + thumbWidth + " h=" + thumbHeight + " name=" + name);
            int ratio1 = (sourceWidth << 8) / thumbWidth;
            int ratio2 = (sourceHeight << 8) / thumbHeight;
            int ratio = Math.max(ratio1, ratio2);
            thumbWidth = (sourceWidth << 8) / ratio;
            thumbHeight = (sourceHeight << 8) / ratio;
            if (thumbWidth == 0 || thumbHeight == 0) {
                throw new RuntimeException("Cannot create thumbnail with size w=" + sourceWidth + " h=" + sourceHeight + " thumb w=" + thumbWidth + " h=" + thumbHeight + " name=" + name);
            }
            int[] rgb = new int[thumbWidth * thumbHeight];
            int y = 0;
            while (y < thumbHeight && FixedMath.roundFix(y * ratio) < sourceHeight) {
                int[] orig = new int[sourceWidth];
                int tmpy = y * thumbWidth;
                image.getRGB(orig, 0, sourceWidth, 0, FixedMath.roundFix(y * ratio), sourceWidth, 1);
                int x = 0;
                while (x < thumbWidth && FixedMath.roundFix(x * ratio) < sourceWidth) {
                    rgb[tmpy + x] = orig[FixedMath.roundFix(x * ratio)];
                    ++x;
                }
                ++y;
            }
            image = Image.createRGBImage((int[])rgb, (int)thumbWidth, (int)thumbHeight, (boolean)true);
            if (cache) {
                Cache.add(prefix, thumbName, image);
            }
        } else {
            image = (Image)Cache.get(prefix, thumbName);
        }
        return image;
    }

    public static Image createImage(String prefix, String name) {
        return Utils.createImage(prefix, name, true);
    }

    public static Image createImage(String prefix, String name, boolean cache) {
        Image tmp = null;
        if (!Cache.contains(prefix, name)) {
            System.err.println("Slow operation for createImage with prefix [" + prefix + "] and name [" + name + "]");
            try {
                StringBuffer sb = new StringBuffer("/");
                sb.append(name);
                if (name.indexOf(".png") < 0) {
                    sb.append(".png");
                }
                tmp = Image.createImage((String)sb.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (cache) {
                Cache.add(prefix, name, tmp);
            }
        } else {
            tmp = (Image)Cache.get(prefix, name);
        }
        return tmp;
    }

    public static Image creteBackground(int width, int heigth, Image texture1, Image texture2) {
        String name = BACKGROUND_PREFIX + width + heigth;
        Image background = null;
        if (!Cache.contains(BACKGROUND_PREFIX, name)) {
            System.err.println("slow operation2 creteBackground");
            background = Image.createImage((int)width, (int)heigth);
            int heightGrass = texture1.getHeight();
            int widthGrass = texture1.getWidth();
            Graphics g = background.getGraphics();
            int tilesx = width / widthGrass + 1;
            int tilesy = heigth / heightGrass + 1;
            TiledLayer tiledLayer1 = new TiledLayer(tilesx, tilesy, texture1, widthGrass, heightGrass);
            tiledLayer1.fillCells(0, 0, tilesx, tilesy, 1);
            tiledLayer1.paint(g);
            int heightRoad = texture2.getHeight();
            int widthRoad = texture2.getWidth();
            tilesx = width / widthRoad + 1;
            tilesy = heigth / heightRoad + 1;
            TiledLayer tiledLayer2 = new TiledLayer(tilesx, tilesy, texture2, widthRoad, heightRoad);
            tiledLayer2.fillCells(0, tilesy / 2, tilesx, tilesy - tilesy / 2, 1);
            tiledLayer2.paint(g);
            int y = tilesy / 2 * heightRoad;
            int tmpw = width / 10;
            int j = 0;
            while (j < heigth / 20) {
                g.setColor(0xC0C0C0);
                int tmpy = y + j;
                int i = 0;
                while (i < width) {
                    g.setColor(g.getColor() == 0xC0C0C0 ? 0xC00000 : 0xC0C0C0);
                    g.drawLine(i, tmpy, i + tmpw, tmpy);
                    i += tmpw;
                }
                ++j;
            }
            Cache.add(BACKGROUND_PREFIX, name, background);
        } else {
            background = (Image)Cache.get(BACKGROUND_PREFIX, name);
        }
        return background;
    }

    public static Image[][] createChoiceImages(int x, int y) {
        Image[][] retImage = new Image[2][9];
        int bias = 4;
        if (!Cache.contains(CHOICE_PREFIX, CHOICE_NAME)) {
            int i = 0;
            while (i < retImage[0].length) {
                Image tmpImage = Utils.createThumbnail(CHOICE_PREFIX, "cs" + (i + 1), x, y);
                int imgHeigth = tmpImage.getHeight();
                int imgWidth = tmpImage.getWidth();
                int[] rgb = new int[(imgWidth + 4) * (imgHeigth + 4)];
                int y1 = 2;
                while (y1 < imgHeigth + 2) {
                    tmpImage.getRGB(rgb, y1 * (imgWidth + 4) + 2, imgWidth, 0, y1 - 2, imgWidth, 1);
                    ++y1;
                }
                Draw.drawBound(rgb, imgWidth + 4, imgHeigth + 4, -8351696);
                retImage[0][i] = Image.createRGBImage((int[])rgb, (int)(imgWidth + 4), (int)(imgHeigth + 4), (boolean)true);
                Draw.drawBound(rgb, imgWidth + 4, imgHeigth + 4, -13606752);
                retImage[1][i] = Image.createRGBImage((int[])rgb, (int)(imgWidth + 4), (int)(imgHeigth + 4), (boolean)true);
                ++i;
            }
            Cache.add(CHOICE_PREFIX, CHOICE_NAME, retImage);
        } else {
            retImage = (Image[][])Cache.get(CHOICE_PREFIX, CHOICE_NAME);
        }
        return retImage;
    }

    public static void loadCharacters(String prefix, int width, int height, int fontColor) {
        Character c;
        int ch = 97;
        int i = 0;
        while (i < 26) {
            c = new Character((char)(ch + i));
            Utils.setAlphabet(c, prefix, c.toString(), width, height, fontColor);
            ++i;
        }
        Utils.setAlphabet(new Character('-'), prefix, Utils.translate('-'), width, height, fontColor);
        Utils.setAlphabet(new Character('.'), prefix, Utils.translate('.'), width, height, fontColor);
        Utils.setAlphabet(new Character(','), prefix, Utils.translate(','), width, height, fontColor);
        Utils.setAlphabet(new Character('?'), prefix, Utils.translate('?'), width, height, fontColor);
        Utils.setAlphabet(new Character('!'), prefix, Utils.translate('!'), width, height, fontColor);
        Utils.setAlphabet(new Character('#'), prefix, Utils.translate('#'), width, height, fontColor);
        Utils.setAlphabet(new Character('/'), prefix, Utils.translate('/'), width, height, fontColor);
        Utils.setAlphabet(new Character(' '), prefix, Utils.translate(' '), width, height, fontColor);
        ch = 48;
        i = 0;
        while (i < 10) {
            c = new Character((char)(ch + i));
            Utils.setAlphabet(c, prefix, c.toString(), width, height, fontColor);
            ++i;
        }
    }

    private static void setAlphabet(Character c, String prefix, String name, int width, int height, int fontColor) {
        Image image = Utils.createThumbnail(prefix, name, width, height, false);
        image = Draw.adaptColor(image, fontColor);
        Cache.add(prefix, name, image);
    }

    private static String translate(char c) {
        switch (c) {
            case '-': {
                return "dash";
            }
            case '.': {
                return "dot";
            }
            case ',': {
                return "comma";
            }
            case '?': {
                return "question";
            }
            case '!': {
                return "exclamation";
            }
            case '#': {
                return "pound";
            }
            case '/': {
                return "slash";
            }
            case ' ': {
                return "space";
            }
        }
        return "" + c;
    }

    private static Point textLineWidth(String prefix, String text) {
        int width = 5;
        int height = 0;
        int textLength = text.length();
        int i = 0;
        while (i < textLength) {
            Image img = (Image)Cache.get(prefix, Utils.translate(text.charAt(i)));
            width += img.getWidth() + 2;
            if (height < img.getHeight() + 2) {
                height = img.getHeight() + 2;
            }
            ++i;
        }
        return new Point(width, height + 2);
    }

    public static Image writeLine(String prefix, String text, int backgroundColor) {
        String name = String.valueOf(text) + backgroundColor;
        Image ret = null;
        if (!Cache.contains(prefix, name)) {
            System.err.println("slow operation2 writeLine " + name);
            Point xy = Utils.textLineWidth(prefix, text);
            int width = xy.getX();
            int height = xy.getY();
            int[] rgb = new int[width * height];
            int[] tmp = new int[width];
            int i = 0;
            while (i < width) {
                tmp[i] = backgroundColor;
                ++i;
            }
            i = 0;
            while (i < height) {
                System.arraycopy(tmp, 0, rgb, i * width, width);
                ++i;
            }
            int x = 2;
            int i2 = 0;
            while (i2 < text.length()) {
                Image img = (Image)Cache.get(prefix, Utils.translate(text.charAt(i2)));
                tmp = new int[img.getWidth() * img.getHeight()];
                img.getRGB(tmp, 0, img.getWidth(), 0, 0, img.getWidth(), img.getHeight());
                Draw.drawRGBImage(rgb, width, height, tmp, x, height - img.getHeight() - 2, img.getWidth(), img.getHeight());
                tmp = null;
                x += img.getWidth() + 2;
                ++i2;
            }
            ret = Image.createRGBImage((int[])rgb, (int)width, (int)height, (boolean)true);
            Cache.add(prefix, name, ret);
            tmp = null;
        } else {
            ret = (Image)Cache.get(prefix, name);
        }
        return ret;
    }
}

