/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

import cellrace.Point;
import cellrace.Rectangle;
import cellrace.StraightLine;
import cellrace.Vector;

public class Line {
    private final int x1;
    private final int y1;
    private final int x2;
    private final int y2;
    private final boolean flip;

    public Line() {
        this(0, 0, 0, 0);
    }

    public Line(Point p1, Point p2) {
        this(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public Line(int x1, int y1, int x2, int y2) {
        this(x1, y1, x2, y2, true);
    }

    public Line(int x1, int y1, int x2, int y2, boolean flip) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.flip = flip;
    }

    public int getX1() {
        return this.x1;
    }

    public int getY1() {
        return this.y1;
    }

    public int getX2() {
        return this.x2;
    }

    public int getY2() {
        return this.y2;
    }

    public boolean intersectsLine(Line line2) {
        return false;
    }

    public boolean isFlip() {
        return this.flip;
    }

    public boolean inside(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(this.x1 < this.x2 ? this.x1 : this.x2, this.y1 < this.y2 ? this.y1 : this.y2, Math.abs(this.x1 - this.x2), Math.abs(this.y1 - this.y2));
        return rectangle2.intersect(rectangle);
    }

    public String toString() {
        return "X1:" + this.x1 + " Y1:" + this.y1 + " X2:" + this.x2 + " Y2:" + this.y2;
    }

    public int length() {
        return (int)Math.sqrt(Math.abs(this.x1 - this.x2) * Math.abs(this.x1 - this.x2) + Math.abs(this.y1 - this.y2) * Math.abs(this.y1 - this.y2));
    }

    public StraightLine toStraightLine() {
        return new StraightLine(new Vector(this.x1, this.y1), new Vector(this.x2, this.y2), false);
    }

    public boolean inside(Point p) {
        int maxX = Math.max(this.getX1(), this.getX2());
        int minX = Math.min(this.getX1(), this.getX2());
        int maxY = Math.max(this.getY1(), this.getY2());
        int minY = Math.min(this.getY1(), this.getY2());
        return p.getX() < maxX && p.getX() > minX && p.getY() < maxY && p.getY() > minY;
    }
}

