/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

import cellrace.CellRaceCanvas;
import cellrace.CellRaceListener;
import cellrace.FinishLoadingListener;
import cellrace.Game;
import cellrace.GameFinishListener;
import cellrace.Loader;
import cellrace.Menu;
import cellrace.Setup;
import cellrace.SplashScreen;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import utils.Sound;

public class CellRace
extends MIDlet {
    private Game game;
    private Menu menu;
    private Display display;
    public static CellRace CELLRACE;
    public static int MAX_PLAYERS;
    private boolean playingCredits = false;

    static {
        MAX_PLAYERS = 6;
    }

    protected void startApp() throws MIDletStateChangeException {
        CELLRACE = this;
        if (this.display == null) {
            try {
                this.initMIDlet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initMIDlet() throws Exception {
        this.display = Display.getDisplay((MIDlet)this);
        try {
            this.display.setCurrent((Displayable)new CellRaceCanvas("Loading..."));
            this.display.setCurrent((Displayable)new SplashScreen(new SplashFinishLoadingListener(), new SplashLoader()));
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public void exit() {
        try {
            this.destroyApp(false);
        }
        catch (MIDletStateChangeException e) {
            e.printStackTrace();
        }
        this.notifyDestroyed();
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
    }

    private class SplashFinishLoadingListener
    implements FinishLoadingListener {
        private SplashFinishLoadingListener() {
        }

        public void finishedLoading() {
            CellRace.this.display.setCurrent((Displayable)CellRace.this.menu.currentCanvas());
        }
    }

    private class SplashLoader
    implements Loader {
        private SplashLoader() {
        }

        public int getSteps() {
            return 1;
        }

        public void loadStep(int step) {
            switch (step) {
                case 0: {
                    CellRace.this.game = new Game(new MyGameFinishListener());
                    CellRace.this.menu = new Menu(new MenuListener(), new MenuFinishLoadingListener(), CellRace.this.game);
                    Sound.playMIDI("intro", false);
                }
            }
        }

        private class MenuListener
        implements CellRaceListener {
            private MenuListener() {
            }

            public void exitGame() {
                CellRace.this.exit();
            }

            public void refreshCanvas() {
                CellRace.this.display.setCurrent((Displayable)CellRace.this.menu.currentCanvas());
                CellRace.this.menu.currentCanvas().repaint();
                if (CellRace.this.menu.getCurrentScrennStatus() == 2 && !CellRace.this.playingCredits) {
                    Sound.stopMIDI();
                    Sound.playMIDI("credits4", false);
                    CellRace.this.playingCredits = true;
                } else if (CellRace.this.playingCredits) {
                    Sound.stopMIDI();
                    Sound.playMIDI("intro", false);
                    CellRace.this.playingCredits = false;
                }
            }

            public void setup(Setup setup) {
                CellRace.this.game.setSetup(setup);
            }
        }

        private class MenuFinishLoadingListener
        implements FinishLoadingListener {
            private MenuFinishLoadingListener() {
            }

            public void finishedLoading() {
                CellRace.this.display.setCurrent((Displayable)CellRace.this.game);
                CellRace.this.game.play();
            }
        }

        private class MyGameFinishListener
        implements GameFinishListener {
            private MyGameFinishListener() {
            }

            public void gameOver() {
                CellRace.this.display.setCurrent((Displayable)CellRace.this.menu.currentCanvas());
                CellRace.this.menu.currentCanvas().repaint();
                CellRace.this.game.clear();
                Sound.playMIDI("intro", false);
            }
        }
    }
}

