float texFix = (1.0f/512.0f)*0.5f;
float amount = 0.5f;

texture texture_0;
sampler texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};


struct VertexInput {
    float3 Position		: POSITION;
    float2 uvCoord		: TEXCOORD0;
};

struct VertexOutput {
    float4 HPosition	: POSITION;
    float2 uvCoord		: TEXCOORD0;
};

VertexOutput VS_QuadProjection(VertexInput IN) {
    VertexOutput OUT;
    
    OUT.HPosition = float4( IN.Position , 1.0f );
    OUT.uvCoord = IN.uvCoord + texFix;
    return OUT;
}

float4 PS_Texture( VertexOutput IN ) : COLOR
{
	return tex2D( texture_0Sampler, IN.uvCoord ) * amount;
}

technique Textured
{
    pass p0 
    {		
		VertexShader = compile vs_1_1 VS_QuadProjection();
		PixelShader = compile ps_1_1 PS_Texture();
		
		ZEnable = false;
		ZWriteEnable = false;
		
		AlphaBlendEnable = true;
		srcBlend = srcAlpha;
		destBlend = one;
    }
}

technique DoMotionBlur< bool quad = true; string material="motionBlur"; >
{
	
}