half texel = 1.0f / 128.0f;
half texFix = (1.0f/128.0f) * 0.5f;

const float gaussianCoefs[7] = { 
0.035994,
0.10934,
0.212965,
0.265962,
0.212965,
0.10934,
0.035994
};

float multiply = 1.0f;

texture renderTexture;

sampler textureSampler = sampler_state 
{
    texture = <renderTexture>;
    AddressU  = CLAMP;        
    AddressV  = CLAMP;
    AddressW  = CLAMP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput {
    float3 Position		: POSITION;
    float2 uvCoord		: TEXCOORD0;
};

struct VertexOutput {
    float4 HPosition	: POSITION;
    float2 uvCoord		: TEXCOORD0;
};



VertexOutput QuadProjection(VertexInput IN) {
    VertexOutput OUT;
    
    OUT.HPosition = float4( IN.Position , 1.0f );
    OUT.uvCoord = IN.uvCoord;
    return OUT;
}

float4 GaussianX( VertexOutput IN ) : COLOR
{
	half4 color = 0;
	for( int r = -3; r <= 3; r+=1 ) {
		color += tex2D( textureSampler, IN.uvCoord + float2(texel*r,0) ) * gaussianCoefs[r+3];
	}
	return color;
}

float4 GaussianY( VertexOutput IN ) : COLOR
{
	half4 color = 0;
	for( int r = -3; r <= 3; r+=1 ) {
		color += tex2D( textureSampler, IN.uvCoord + float2(0, texel*r) ) * gaussianCoefs[r+3];
	}
	return color;
}

float4 PS_CopyTexture( VertexOutput IN ) : COLOR
{
	return tex2D( textureSampler, IN.uvCoord );
}

technique BlurX
{
    pass p0 
    {		
		VertexShader = compile vs_1_1 QuadProjection();
		PixelShader = compile ps_2_0 GaussianX();
		
		ZWriteEnable = false;
		
		AlphaBlendEnable = true;
		srcBlend = one;
		destBlend =zero;
    }
}

technique BlurY
{
    pass p0 
    {		
		VertexShader = compile vs_1_1 QuadProjection();
		PixelShader = compile ps_2_0 GaussianY();
		
		ZWriteEnable = false;
		
		AlphaBlendEnable = true;
		srcBlend = one;
		destBlend =invsrcColor;
    }
}

technique CopyTexture
{
	pass p0
	{
		VertexShader = compile vs_1_1 QuadProjection();
		PixelShader = compile ps_1_1 PS_CopyTexture();
		
		ZWriteEnable = false;
	}
}

technique CopyTextureBlended
{
	pass p0
	{
		VertexShader = compile vs_1_1 QuadProjection();
		PixelShader = compile ps_1_1 PS_CopyTexture();
		
		ZWriteEnable = false;
		
		AlphaBlendEnable = true;
		srcBlend = one;
		destBlend =invsrcColor;
	}
}