float4x4 comboMatrix : WorldViewProjection;

float4	materialColor = { 1.0f, 1.0f, 1.0f, 1.0f };

float4 VS_VertexTransform( float3 position : POSITION ) : POSITION
{
	return mul( float4(position, 1.0f), comboMatrix );
}

float4 PS_Material( float4 position : POSITION ) : COLOR
{
	return materialColor;
}

technique PosMaterial< bool quad=true; string material="gaussian"; >
{
	pass p0
	{
		VertexShader = compile vs_1_1 VS_VertexTransform();
		PixelShader  = compile ps_1_1 PS_Material();
	}
}