NR = 9
NPR = 23
RINGL = 1.0
WIDTH = 41
function P_vorteksp() {
    OFFSET_VECTOR.reset()
    flash = new Div('white', 512, 384)
    flash.img.style.zIndex = 8080
    flash.moveXY(256,192)
    flash.hide()
    rings = new Array(NR)
    pix = new Array(NR * NPR)
    text = new Text('<span style="font-family:sans-serif">HyperSpace Warp Vortex Device activated</span>')
    text.img.style.zIndex = 8008
    text.img.style.left = '32px'
    text.img.style.top = '80px'
    text.hide()
    ffa = new Div('black', 512, 160)
    ffb = new Div('black', 513, 160)
    ffa.moveXY(256, 64)
    ffb.moveXY(256, 320)
    ffa.img.style.zIndex = 8000
    ffb.img.style.zIndex = 8000
    document.getElementById('d').style.backgroundColor = '#002'
    flare = new Div('white', 64, 64)
    flare2 = new Pic('data/p.png', 196, 196)
    flare2.hide()
    for (var i = 0; i < NR; ++i) {
        rings[i] = new Array(NPR)
        for (var j = 0; j < NPR - i*2; ++j) {
            var angle = j / (NPR - i*2) * 2 * Math.PI + i / 2
            var rad = 0.4 - i / (3.4*NR)
            with (Math) rings[i][j] = new Vector3D(RINGL * i / NR - RINGL / 2, rad * sin(angle), rad * cos(angle))
            var m = NR - i
            var a = '11223445789cdef'.charAt(m+j%2+1 - i / 3)
            var b = '11223445789cdef'.charAt(m+j%2+Math.floor((i/NR*1.15)*5) - i / 3)
            var c = '11223445789cdef'.charAt(m+j%2+4 - i / 3)
            var col = '#' + a + b + c
            pix[j + i * NPR] = new Div(col, WIDTH, WIDTH)
            pix[j + i * NPR].img.style.zIndex = 501
        }
    }
    P_vorteks(0)
}
function P_vortekse() {
    ffa.free()
    ffb.free()
    text.free()
    flash.free()
    flare.free()
    flare2.free()
    for (var i = 0; i < NR; ++i) {
        for (var j = 0; j < NPR - 2*i; ++j) {
            pix[j + i * NPR].free()
        }
        delete rings[i]
    }
    delete rings
    delete pix
    ROTATION_MATRIX.reset()
    OFFSET_VECTOR.x = 0
    OFFSET_VECTOR.y = 0
    OFFSET_VECTOR.z = 0
}

function P_vorteks(pttime) {
    /*
    rotate3d2(Math.PI/2)
    rotate3d3(pttime / 200)
    rotate3d1(pttime / 300)
    rotate3d2(pttime / 400)
    for (var i = 0; i < NR; ++i) {
        for (var j = 0;  j < NPR; ++j) {
            pix[j + i * NPR].move3d(rings[i][j], 1.0)
        }
    }
    ROTATION_MATRIX.reset()
    */
/*
    for (var i = 0; i < NR; ++i) {
        rotate3d2(Math.PI/2)
        rotate3d2(Math.sin(pttime / 1600))
        rotate3d1(Math.cos(pttime / 1000))
        rotate3d3(pttime / 1600 * (2+i))
        var tmp = OFFSET_VECTOR.z
        OFFSET_VECTOR.z += i/NR * (1.4+Math.sin(pttime/400))
        for (var j = 0;  j < NPR; ++j) {
            pix[j + i * NPR].move3d(rings[i][j], 1.0)
        }
        OFFSET_VECTOR.z = tmp
    ROTATION_MATRIX.reset()
    }
    */

    //rotate3d1(pttime / 1200)
    //rotate3d2(pttime / 1600)
    //rotate3d3(pttime / 900)
    //OFFSET_VECTOR.z = 1.4
    if (pttime < 3000) {
        OFFSET_VECTOR.z = 8 - 8 * pttime / 3000
        flash.show()
        flash.img.style.backgroundColor = 'black'
        flash.alpha(1-(pttime-1000)/2000)
    }
    else if (pttime < 4000) {
        flash.img.style.backgroundColor = 'white'
        flash.hide()
        OFFSET_VECTOR.z = 0
        text.show()
        text.alpha((pttime-3000)/800)
    }
    else if (pttime > 4000 && pttime < 8000)
        text.alpha(1)
    else if (pttime > 8000 && pttime < 15000) {
        OFFSET_VECTOR.z = - 7 * (pttime - 8000) / 13000
        if (pttime > 10500) {
            flash.show()
            flash.alpha((pttime-10500)/1500)
        }
    }
    var vec = new Vector3D(0.44, 0, 0)
    for (var i = 0; i < 1+NR; ++i) {
        rotate3d2(Math.sin(0.24 + OFFSET_VECTOR.z / 8))
        rotate3d1(Math.sin(0.24 + OFFSET_VECTOR.z / 8))
        rotate3d2(Math.PI/2 + Math.sin(pttime/800)/40)
        rotate3d3((pttime/600*((NR-i)/5.9235199)+i/2))
        if (i == NR) {
            flare.move3d(vec, 0.8)
            if (pttime > 11000) {
                flare2.show()
                flare2.move3d(vec, 0.3 + (pttime-11000)/2000)
                flare2.img.style.zIndex = 1800
            }
        }
        else {
            for (var j = 0; j < NPR - 2*i; ++j) {
                var tmp = new Vector3D()
                tmp.x = rings[i][j].x
                tmp.y = rings[i][j].y
                tmp.z = rings[i][j].z
                tmp.transform(ROTATION_MATRIX)
                tmp.x += OFFSET_VECTOR.x
                tmp.y += OFFSET_VECTOR.y
                tmp.z += OFFSET_VECTOR.z
                if (tmp.z > -1.8) {
                    pix[j + i * NPR].show()
                    pix[j + i * NPR].move3d(rings[i][j], 1)
                }
                else 
                    pix[j + i * NPR].hide()
            }
        }
    ROTATION_MATRIX.reset()
    }
}
