function Pic_alpha(a) {
    this.img.style.opacity = a
}
function Pic_move3d(vec, scale) {
    vect = new Vector3D()
    vect.x = vec.x
    vect.y = vec.y
    vect.z = vec.z
    vect.transform(ROTATION_MATRIX)
    vect.x += OFFSET_VECTOR.x
    vect.y += OFFSET_VECTOR.y
    vect.z += OFFSET_VECTOR.z
    if(vect.z < -2) {
        this.hide()
    }
    else {
        this.show()
    }
    var xp = 256 + (vect.x / (vect.z + 2.0)) * 256.0;
    var yp = 192 + (vect.y / (vect.z + 2.0)) * 256.0;
    var s  = scale / (2 + vect.z);
    this.moveXY(xp, yp, s);
    this.img.style.zIndex = Math.floor(512 * (1.0 - (1 + vect.z) / 2))
    if (this.img.style.zIndex < 1)
        this.img.style.zIndex = 8
}   
function Pic_moveXY(x, y, s) {
    s = s ? s : 1
    with (Math) {
        this.img.style.left = x - floor(s * this.width / 2) + 'px'
        this.img.style.top = y - floor(s * this.height / 2) + 'px'
        this.img.style.width = floor(s * this.width) + 'px'
        this.img.style.height = floor(s * this.height) + 'px'
    }
//    this.img.style.zIndex = 100
}
function Pic_hide() {
    this.visible = 0
    this.img.style.visibility = 'hidden'
}
function Pic_show() {
    this.visible = 1
    this.img.style.visibility = 'visible'
}
function Pic_setWidth(w) {
    this.width = w
}
function Pic_free() {
    document.getElementById('d').removeChild(this.img)
}
function Pic(fn, w, h) {
    this.width = w
    this.height = h
    this.img = document.createElement('img')
    this.img.style.display='block'
    this.img.src = fn
    document.getElementById('d').appendChild(this.img)
    // defaults
    this.visible = 1
    this.img.style.visibility = 'visible'
    this.img.style.position = 'absolute'
    // methods
    this.show = Pic_show
    this.hide = Pic_hide
    this.moveXY = Pic_moveXY
    this.move3d = Pic_move3d
    this.alpha = Pic_alpha
    this.free = Pic_free
}
