function Div_alpha(a) {
    this.img.style.opacity = a
}
function Div_move3d(vec, scale) {
    scale = scale ? scale : 1
    vect = new Vector3D()
    vect.x = vec.x
    vect.y = vec.y
    vect.z = vec.z
    vect.transform(ROTATION_MATRIX)
    vect.x += OFFSET_VECTOR.x
    vect.y += OFFSET_VECTOR.y
    vect.z += OFFSET_VECTOR.z
    vect.z < -2.0 ? this.hide() : this.show()
    var xp = 256 + (vect.x / (vect.z + 2.0)) * 256.0;
    var yp = 192 + (vect.y / (vect.z + 2.0)) * 256.0;
    var s  = scale / (2 + vect.z);
    this.moveXY(xp, yp, s);
    this.img.style.zIndex = Math.floor(512 * (3.0 - (1 + vect.z) / 2))
}

function Div_moveXY(x, y, s) {
    s = s ? s : 1
    with (Math) {
        this.img.style.left = x - floor(s * this.width / 2) + 'px'
        this.img.style.top = y - floor(s * this.height / 2) + 'px'
        this.img.style.width = floor(s * this.width) + 'px'
        this.img.style.height = floor(s * this.height) + 'px'
    }
}
function Div_hide() {
    this.visible = 0
    this.img.style.visibility = 'hidden'
}
function Div_show() {
    this.visible = 1
    this.img.style.visibility = 'visible'
}
function Div_setWidth(w) {
    this.width = w
}
function Div_free() {
    document.getElementById('d').removeChild(this.img)
}
function Div(col, w, h) {
    this.width = w
    this.height = h
    this.img = document.createElement('div')
    this.img.style.display='block'
    this.img.style.backgroundColor = col
    document.getElementById('d').appendChild(this.img)

    this.visible = 1
    this.img.style.visibility = 'visible'
    this.img.style.position = 'absolute'

    this.show = Div_show
    this.hide = Div_hide
    this.moveXY = Div_moveXY
    this.move3d = Div_move3d
    this.alpha = Div_alpha
    this.free = Div_free
    this.setWidth = Div_setWidth
}
