/* vector operations */

/* a transform is a function that takes a matrix and t, and returns that matrix postmultiplied by
the transform matrix (which may vary over t) */

function constTranslation(x,y,z) {
	return function(m, t) {
		return [
			m[0], m[1], m[2], m[0]*x + m[1]*y + m[2]*z + m[3],
			m[4], m[5], m[6], m[4]*x + m[5]*y + m[6]*z + m[7],
			m[8], m[9], m[10], m[8]*x + m[9]*y + m[10]*z + m[11]
		];
	}
}

function constXRotation(a) {
	var cos_a = Math.cos(a);
	var sin_a = Math.sin(a);
	return function(m, t) {
		return [
			m[0], m[1]*cos_a+m[2]*sin_a, m[2]*cos_a-m[1]*sin_a, m[3],
			m[4], m[5]*cos_a+m[6]*sin_a, m[6]*cos_a-m[5]*sin_a, m[7],
			m[8], m[9]*cos_a+m[10]*sin_a, m[10]*cos_a-m[9]*sin_a, m[11]
		];
	}
}

function constYRotation(a) {
	var cos_a = Math.cos(a);
	var sin_a = Math.sin(a);
	return function(m, t) {
		return [
			m[0]*cos_a-m[2]*sin_a, m[1], m[0]*sin_a+m[2]*cos_a, m[3],
			m[4]*cos_a-m[6]*sin_a, m[5], m[4]*sin_a+m[6]*cos_a, m[7],
			m[8]*cos_a-m[10]*sin_a, m[9], m[8]*sin_a+m[10]*cos_a, m[11]
		];
	}
}

function constZRotation(a) {
	var cos_a = Math.cos(a);
	var sin_a = Math.sin(a);
	return function(m, t) {
		return [
			m[0]*cos_a+m[1]*sin_a, m[1]*cos_a-m[0]*sin_a, m[2], m[3],
			m[4]*cos_a+m[5]*sin_a, m[5]*cos_a-m[4]*sin_a, m[6], m[7],
			m[8]*cos_a+m[9]*sin_a, m[9]*cos_a-m[8]*sin_a, m[10], m[11]
		];
	}
}

function xRotation(f) {
	return function(m, t) {
		var a = f(t);
		var cos_a = Math.cos(a);
		var sin_a = Math.sin(a);
		return [
			m[0], m[1]*cos_a+m[2]*sin_a, m[2]*cos_a-m[1]*sin_a, m[3],
			m[4], m[5]*cos_a+m[6]*sin_a, m[6]*cos_a-m[5]*sin_a, m[7],
			m[8], m[9]*cos_a+m[10]*sin_a, m[10]*cos_a-m[9]*sin_a, m[11]
		];
	}
}

function yRotation(f) {
	return function(m, t) {
		var a = f(t);
		var cos_a = Math.cos(a);
		var sin_a = Math.sin(a);
		return [
			m[0]*cos_a-m[2]*sin_a, m[1], m[0]*sin_a+m[2]*cos_a, m[3],
			m[4]*cos_a-m[6]*sin_a, m[5], m[4]*sin_a+m[6]*cos_a, m[7],
			m[8]*cos_a-m[10]*sin_a, m[9], m[8]*sin_a+m[10]*cos_a, m[11]
		];
	}
}

function zRotation(f) {
	return function(m, t) {
		var a = f(t);
		var cos_a = Math.cos(a);
		var sin_a = Math.sin(a);
		return [
			m[0]*cos_a+m[1]*sin_a, m[1]*cos_a-m[0]*sin_a, m[2], m[3],
			m[4]*cos_a+m[5]*sin_a, m[5]*cos_a-m[4]*sin_a, m[6], m[7],
			m[8]*cos_a+m[9]*sin_a, m[9]*cos_a-m[8]*sin_a, m[10], m[11]
		];
	}
}

/* function makeCameraMatrix(c, v) {
	var d = [v[0] - c[0], v[1] - c[1], v[2] - c[2]];
	var yz = Math.sqrt(d[1]*d[1] + d[2]*d[2]);
	var xyz = Math.sqrt(yz*yz + d[0]*d[0]);
	var sin_a = d[1] / yz; var cos_a = d[2] / yz;
	var sin_b = -d[0] / xyz; var cos_b = yz / xyz;
	if (d[2] < 0 && d[0] > 0) cos_b = -cos_b;
	// intermediate products...
	var ips = [sin_b * sin_a, sin_b * cos_a, cos_b*sin_a, cos_b*cos_a];
	return [
		cos_b, ips[0], ips[1], -cos_b*c[0] - ips[0]*c[1] - ips[1]*c[2],
		0, cos_a, -sin_a, -cos_a*c[1] + sin_a*c[2],
		-sin_b, ips[2], ips[3], sin_b*c[0] - ips[2]*c[1] - ips[3]*c[2]
	];
} */

function avgVectors(a,b,c) {
	return [(a[0]+b[0]+c[0]) / 3, (a[1]+b[1]+c[1]) / 3, (a[2]+b[2]+c[2]) / 3];
}

function negateVector(v) {
	return [-v[0], -v[1], -v[2]];
}

function normalise(v) {
	var mod = Math.sqrt(v[0]*v[0] + v[1]*v[1] + v[2]*v[2]);
	return [v[0] / mod, v[1] / mod, v[2] / mod];
}

function dotProduct(a, b) {
	return (a[0]*b[0] + a[1]*b[1] + a[2]*b[2]);
}

function crossProduct(a,b) {
	return [a[1]*b[2] - a[2]*b[1], a[2]*b[0] - a[0]*b[2], a[0]*b[1] - a[1]*b[0]];
}

function makeCameraMatrix(pos, target, up) {
	if (!up) up = [0, 1, 0];
	var z = normalise([target[0] - pos[0], target[1] - pos[1], target[2] - pos[2]]);
	var x = normalise(crossProduct(up, z));
	var y = crossProduct(z, x);
	return [
		x[0], x[1], x[2], -dotProduct(x, pos),
		y[0], y[1], y[2], -dotProduct(y, pos),
		z[0], z[1], z[2], -dotProduct(z, pos)
	]
}

function transformVector(v, m) {
	return [
		v[0]*m[0] + v[1]*m[1] + v[2]*m[2] + m[3],
		v[0]*m[4] + v[1]*m[5] + v[2]*m[6] + m[7],
		v[0]*m[8] + v[1]*m[9] + v[2]*m[10] + m[11]
	];
}

function transformNormal(v, m) {
	return [
		v[0]*m[0] + v[1]*m[1] + v[2]*m[2],
		v[0]*m[4] + v[1]*m[5] + v[2]*m[6],
		v[0]*m[8] + v[1]*m[9] + v[2]*m[10]
	];
}
