/* stonehenge scene */

var stonehengeScene;

var SH_CAMERA_RADIUS = 30;
var HENGE_COUNT = 9;

var SH_FADEON_TIME = 500;
var SH_FADE_TIME = 2000;

var SH_SHOT_1_LENGTH = 21000;
var SH_SHOT_2_LENGTH = 21000;

function pet(n) { /* peturb vertices */
	return n - 0.08 + Math.random()*0.16;
}

function initStonehengeScene() {
	var sceneSubjects = [ {light: [5, 8, -30]} ];
	for (var i = 0; i < HENGE_COUNT; i++) {
		sceneSubjects.push(makeHenge(2 * Math.PI * i / HENGE_COUNT));
	}
	stonehengeScene = {
		subjects: sceneSubjects
	};
}

function startStonehengeScene() {
	PERSPECTIVE_ALTERING_MINDFUCK_RATIO = 0;
	PROJECTION_CENTRE_X = CANVAS_WIDTH / 2;
	AMBIENT_LEVEL = 80;
	FOC = 4;
	GROUND_COLOUR = '#009900';
}

function makeHenge(rota) {
	return {
		transform: constYRotation(rota),
		subjects: [
			{ transform: constTranslation(0, 0, -25),
			subjects: [
				{ transform: constTranslation(-2.5, 0, 0), subjects: [makeVerticalObelisk()]},
				{ transform: constTranslation(2.5, 0, 0), subjects: [makeVerticalObelisk()]},
				attachFaceNormals({
					model: renderFlat, lighting: LIGHT_LAMBERTIAN, colour: greyStone,
					v: [
						[pet(-3.9), 6, pet(-1.4)], [pet(3.9), 6, pet(-1.4)], [pet(3.9), 6, pet(1.4)], [pet(-3.9), 6, pet(1.4)],
						[pet(-3.9), pet(6.8), pet(-1.4)], [pet(3.9), pet(6.8), pet(-1.4)], [pet(3.9), pet(6.8), pet(1.4)], [pet(-3.9), pet(6.8), pet(1.4)]
					],
					p: [
						[0,2,1], [0,3,2],
						[0,5,4], [0,1,5], [1,6,5], [1,2,6], [2,7,6], [2,3,7], [3,4,7], [3,0,4],
						[4,5,7], [5,6,7]
					]
				})
			]}
		]
	}
}

function makeVerticalObelisk() {
	return attachFaceNormals({
		model: renderFlat, lighting: LIGHT_LAMBERTIAN, colour: greyStone,
		v: [
			[pet(-1), 0, pet(-1)], [pet(1), 0, pet(-1)], [pet(1), 0, pet(1)], [pet(-1), 0, pet(1)],
			[pet(-1.2), pet(3), pet(-1.2)], [pet(1.2), pet(3), pet(-1.2)], [pet(1.2), pet(3), pet(1.2)], [pet(-1.2), pet(3), pet(1.2)],
			[pet(-1), 6, pet(-1)], [pet(1), 6, pet(-1)], [pet(1), 6, pet(1)], [pet(-1), 6, pet(1)]
		],
		p: [
			[0,1,4], [1,5,4], [1,2,5], [2,6,5], [2,7,6], [2,3,7], [3,4,7], [3,0,4],
			[4,9,8], [4,5,9], [5,10,9], [5,6,10], [6,7,10], [7,11,10], [7,4,11], [4,8,11]
		]
	});
}

function stonehengeShot1(t) {
	var cam_angle = 2 * Math.PI * (t % 25000) / 25000;
	var camera = [SH_CAMERA_RADIUS * Math.sin(cam_angle), 1, SH_CAMERA_RADIUS * -Math.cos(cam_angle)];
	var lookingAt = [0, 3, 0];
	
	renderFrame(stonehengeScene, camera, lookingAt, t, true);

	if (t > SH_SHOT_1_LENGTH - SH_FADE_TIME) {
		var fadeAmount = (t - SH_SHOT_1_LENGTH + SH_FADE_TIME) / SH_FADE_TIME;
		ctx.fillStyle = "rgba(0, 0, 0, " + fadeAmount + ")";
		ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);		
	}
}
function stonehengeShot2(t) {
	var y_angle = 7 * Math.PI * t / (6 * SH_SHOT_2_LENGTH) - 5 * Math.PI/6;
	var cam_angle = 2 * Math.PI * (t % 25000) / 25000;
	var camera = [SH_CAMERA_RADIUS * Math.sin(cam_angle), 12 + 12 * Math.sin(y_angle), SH_CAMERA_RADIUS * -Math.cos(cam_angle)];
	var lookingAt = [0, 3, 0];
	
	renderFrame(stonehengeScene, camera, lookingAt, t, true);
	if (t < SH_FADEON_TIME) {
		var fadeAmount = 1 - (t / SH_FADEON_TIME);
		ctx.fillStyle = "rgba(0, 0, 0, " + fadeAmount + ")";
		ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);		
	} else if (t > SH_SHOT_2_LENGTH - SH_FADE_TIME) {
		var fadeAmount = (t - SH_SHOT_2_LENGTH + SH_FADE_TIME) / SH_FADE_TIME;
		ctx.fillStyle = "rgba(0, 0, 0, " + fadeAmount + ")";
		ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);		
	}
}

function doStonehengeScene(t) {
	if (t < SH_SHOT_1_LENGTH) {
		stonehengeShot1(t);
	} else if (t < SH_SHOT_1_LENGTH + SH_SHOT_2_LENGTH) {
		stonehengeShot2(t - SH_SHOT_1_LENGTH);
	} else {
		ctx.fillStyle = "#000000";
		ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);		
	}
	
}