/* helix scene */

var HELIX_BG_FADE_ON_TIME = 10000;
var HELIX_BG_FADE_ON_DURATION = 1500;
var HELIX_BG_FADE_OFF_TIME = 19000;
var HELIX_SHIFT_TIME = 19000;
var HELIX_SHIFT_DURATION = 4000;

var HELIX_ACCEL_DURATION = 6000;

var HELIX_COMPRESSION = 4;

var splatteringsImg;
var helixBlobImg;

var helixScene;

function makeHelix(r, div, comp, len) {
	/* r = radius; div = number of divisions of one rotation; comp = z-extent of one rotation, len = number of rotations */
	var v = [];
	for (i = 0; i < div*len; i++) {
		var th = i * 2 * Math.PI / div;
		v.push([r * Math.cos(th), r * Math.sin(th), comp*i/div]);
	}
	return {model: renderSprites, v: v, image: helixBlobImg, size: 64};
}

function initHelixScene() {
	splatteringsImg = new Image();
	splatteringsImg.src = 'data/splatterings.jpg';	
	helixBlobImg = new Image();
	helixBlobImg.src = 'data/helix_blob.png';	

	helixScene = {
		subjects: [
			{
				transform: zRotation(function(t) {return Math.PI * (t % 20000) / 10000;}),
				subjects: [
					makeHelix(1.5, 6, HELIX_COMPRESSION, 10)
				]
			}
		]
	}
}

function startHelixScene() {
	PERSPECTIVE_ALTERING_MINDFUCK_RATIO = 1;
	AMBIENT_LEVEL = 100;
}


function helixBgFadeOn(t) {
	var opacity = t / HELIX_BG_FADE_ON_DURATION;
	var stretch_amt = 1 - Math.cos((1 - opacity) * Math.PI/2);
	ctx.drawImage(splatteringsImg, -(3000 * stretch_amt), 0, CANVAS_WIDTH + (4000 * stretch_amt), CANVAS_HEIGHT);
	ctx.fillStyle = "rgba(32, 0, 0, " + (1 - Math.pow(opacity,3)) + ")";
	ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);	
}

function helixBgFadeOff(t) {
	var X = 6; var Y = 4; var FADE_INTERVAL = 200; var FADE_LENGTH = 1000;
	var tileWidth = CANVAS_WIDTH / X; var tileHeight = CANVAS_HEIGHT / Y;
	for (var y = 0; y < Y; y++) {
		for (var x = 0; x < X; x++) {
			var fadeStart = FADE_INTERVAL * (X - x - 1 + y);
			var fadeEnd = fadeStart + FADE_LENGTH;
			if (t < fadeStart) {
				ctx.drawImage(splatteringsImg,
					tileWidth * x, tileHeight * y, tileWidth, tileHeight,
					tileWidth * x, tileHeight * y, tileWidth, tileHeight);
			} else {
				ctx.fillStyle = "#222222";
				ctx.fillRect(x * tileWidth, y * tileHeight, tileWidth, tileHeight);
				if (t < fadeEnd) {
					var fadedness = 1 - (t - fadeStart) / FADE_LENGTH;
					var xSize = fadedness * tileWidth;
					var ySize = fadedness * tileHeight;
					ctx.drawImage(splatteringsImg,
						tileWidth * x, tileHeight * y, tileWidth, tileHeight,
						tileWidth * x + (tileWidth - xSize)/2, tileHeight * y + (tileHeight - ySize)/2, xSize, ySize);
				}
			}
		}
	}
}

function doHelixScene(t) {
	if (t < HELIX_BG_FADE_ON_TIME) {
		ctx.fillStyle = "rgb(32, 0, 0)";
		ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
	} else if (t < HELIX_BG_FADE_ON_TIME + HELIX_BG_FADE_ON_DURATION) {
		helixBgFadeOn(t - HELIX_BG_FADE_ON_TIME);
	} else if (t < HELIX_BG_FADE_OFF_TIME) {
		ctx.drawImage(splatteringsImg, 0, 0);
	} else if (t < HELIX_BG_FADE_OFF_TIME + 4000 /* 4000 = wild guess at how long it takes */) {
		helixBgFadeOff(t - HELIX_BG_FADE_OFF_TIME);
	} else {
		ctx.fillStyle = '#222222';
		ctx.fillRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
	}

	var camera;
	var cam_z;
	if (t < HELIX_SHIFT_TIME) {
		PERSPECTIVE_ALTERING_MINDFUCK_RATIO = 1;
		camera = [0, 0, 0];
		cam_z = 0;
		PROJECTION_CENTRE_X = CANVAS_CENTRE_Y;
	} else {
		if (t < HELIX_SHIFT_TIME + HELIX_SHIFT_DURATION) {
			var shift_point = (t - HELIX_SHIFT_TIME) / HELIX_SHIFT_DURATION;
			PERSPECTIVE_ALTERING_MINDFUCK_RATIO = 1 - shift_point;
			PROJECTION_CENTRE_X = CANVAS_CENTRE_Y * (1-shift_point) + CANVAS_CENTRE_X * shift_point;
		} else {
			// if (!confirm(FOC)) alert(fsdgsdfg);
			PERSPECTIVE_ALTERING_MINDFUCK_RATIO = 0;
			PROJECTION_CENTRE_X = CANVAS_CENTRE_X;
		}
		var localT = t - HELIX_SHIFT_TIME;
		cam_x = Math.min(5, localT / 500);
		//if (t < HELIX_SHIFT_TIME + HELIX_ACCEL_DURATION)
		cam_z = (localT / 200) % HELIX_COMPRESSION + HELIX_COMPRESSION;
		//cam_z = (20 * (1 - Math.cos(Math.PI * localT / HELIX_ACCEL_DURATION))) % HELIX_COMPRESSION + HELIX_COMPRESSION;
		camera = [cam_x, 0, cam_z];
	}
	var lookingAt = [0, 0, 1 + cam_z];
	
	renderFrame(helixScene, camera, lookingAt, t);

}