uniform sampler2D texture;
varying vec2 vTexCoord;
uniform float slider;
uniform float slider2;
uniform float time;

vec2 samples[12];

void main(void)
{
   vec2 newCoord;
   newCoord = vTexCoord;
   newCoord.y = newCoord.y + (sin(cos((time)/3.0+(newCoord.x)*10.0)*2.0)*0.01);

   vec4 sum = texture2D(texture, vec2(newCoord)) * 2.5;
   vec4 org = texture2D(texture, vec2(newCoord)) * 2.5;

  
   samples[0]  = vec2(-0.326212, -0.405805);
   samples[1]  = vec2(-0.840144, -0.073580);
   samples[2]  = vec2(-0.695914,  0.457137);
   samples[3]  = vec2(-0.203345,  0.620716); 
   samples[4]  = vec2( 0.962340, -0.194983);
   samples[5]  = vec2( 0.473434, -0.480026);
   samples[6]  = vec2( 0.519456,  0.767022);
   samples[7]  = vec2( 0.185461, -0.893124);
   samples[8]  = vec2( 0.507431,  0.064425);
   samples[9]  = vec2( 0.896420,  0.412458);
   samples[10] = vec2(-0.321940, -0.932615);
   samples[11] = vec2(-0.791559, -0.597705);


   sum /= 2.5;

   for (int i = 0; i < 12; i++)
   {
      sum += texture2D(texture, vec2(newCoord)+slider * samples[i]) ;
      org += texture2D(texture, vec2(newCoord)+slider * samples[i]) ;
   
   }
   
   sum /= 12.0;
   org /= 12.0;
   
   vec4 color =    vec4(org+(sum));
   float lum = ((color.r * 0.299) + (color.g * 0.587) + (color.b * 0.114));
   vec4 diff = vec4(lum, lum, lum,0) - color;
   color += diff * slider2;

   gl_FragColor = color;
}