
struct output_t
{
  float4 position : POSITION;
  float2 texCoord : TEXCOORD0;
};

float speed;
float random;
float amplitude;

output_t main(float3 position : POSITION, float2 texCoord : TEXCOORD0)
{
  output_t vsOut;
  vsOut.position = float4(position, 1.0f);
  float yPos = position.y + 5.0f;
  float offset = yPos * yPos * yPos * random * speed;
  vsOut.position.x += amplitude * (-0.5 + frac(offset));
  vsOut.texCoord = texCoord;
  return vsOut;
}
