package Program;

BEGIN {
	# export these 
	*{main::NEW} = \&Program::NEW;
	*{main::DEL} = \&Program::DEL;
	*{main::FLT} = \&Program::FLT;
	*{main::SET} = \&Program::SET;
}

sub NEW() { return 1; }
sub DEL() { return 2; }
sub FLT() { return 3; }
sub SET() { return 4; }

sub logstr($) {
	my ($str) = @_;

	# print $str;
	
}

sub is_numeric {
	return defined eval { $_[ 0] == 0 };
} 

sub new($$) {
	my ($class, $dc) = @_;


	my $self = {dc => $dc};

	$self->{"curevent"} = 0;
	$self->{"layers"} = [];

	bless $self;

	return $self;
}

sub SetParams($$) {
	my ($self,$params) = @_;
	my $key;

	foreach $key (keys %{$params}) {
		if($key eq "program") {
			# Load program
			$self->LoadProgram($params->{$key});
		} else {
			$self->{"params"}->{$key} = $params->{$key};
		}
	}
}

sub Render($$) {
	my ($self, $msec) = @_;

	my $curevent = $self->{"curevent"};

	logstr( "Render frame @ $msec msec\n" );

	# Scan through the event list to see if anything should be started or ended

	if($curevent >= @{$self->{"program"}}) {
		return 1;
	}

	while(defined($self->{"program"}->[$curevent]) && $self->{"program"}->[$curevent]->[0] <= $msec) {
		my $event = $self->{"program"}->[$curevent];

		if($event->[1] == 1) {

			logstr( "Event @ " . $event->[0] . " msec: new " . $event->[3] . " object\n" );

			# Call the package's constructor
			my $engine = &{$event->[5] . "::new"} ($event->[5], $self->{"dc"});

			$engine->SetParams($event->[4]);

			$self->RemoveLayer($event->[3]);
			$self->AddLayer($engine, $event->[3], $event->[2], $curevent);

			# Find next float point and add it if necessary

			my $nextevent = $self->FindNextFlt($curevent, $event->[3]);

			if(defined($nextevent)) {
				logstr( "Found FLT for object at event $nextevent\n" );
				$self->FloatLayer($event->[3], $nextevent);
			} else {
				logstr( "No FLT after event $event->[0] msec, freezing $event->[3] object\n" );
				$self->FloatLayer($event->[3], 0);
			}
		}
		elsif($self->{"program"}->[$curevent]->[1] == DEL) {
			logstr( "Event @ $event->[0] msec, DEL $event->[3] object\n" );

			RemoveLayer($event[3]);

		}
		elsif($self->{"program"}->[$curevent]->[1] == FLT) {
			# Passed a float point, find the next and set it

			logstr( "Event @ $event->[0] msec, FLT $event->[3] object\n" );

			my %params = %{$self->{"program"}->[$curevent]->[6]};
			$self->{"program"}->[$curevent]->[4] = \%params;
#			printf "last $curevent" . join(",",%params) . "\n";

			my $nextevent = $self->FindNextFlt($curevent, $event->[3]);

			if(defined($nextevent)) {
				logstr( "Found FLT for object at event $nextevent\n" );
				$self->FloatLayer($event->[3], $nextevent);
			} else {
				logstr( "No FLT after event $event->[0] msec, freezing $event->[3] object\n" );
				$self->FloatLayer($event->[3], 0);
			}

		}
		elsif($self->{"program"}->[$curevent]->[1] == SET) {
			# Found a SET point (har har)

			logstr( "Event @ $event->[0] msec, SET $event->[3] object\n" );

			$self->SetLayer($event->[3], $event->[4]);

			# Find next float point and add it if necessary

			my $nextevent = $self->FindNextFlt($curevent, $event->[3]);

			if(defined($nextevent)) {
				logstr( "Found FLT for object at event $nextevent\n" );
				$self->FloatLayer($event->[3], $nextevent);
			} else {
				logstr( "No FLT after event $event->[0] msec, freezing $event->[3] object\n" );
				$self->FloatLayer($event->[3], 0);
			}
		}

		$curevent++;
	}

	# Scan through the current effects to see if they should be floated to a next value
	foreach $layer (@{$self->{"layers"}}) {
		if(defined($layer->{"fltevent"})) {
			# This layer has a 'float' param, so it should be smoothly moved to the following pos
			my $msecstart = $self->{"program"}->[$layer->{"curevent"}]->[0];
			my $msecend = $self->{"program"}->[$layer->{"fltevent"}]->[0];
			my $paramstart = $self->{"program"}->[$layer->{"curevent"}]->[4];
			my $paramend = $self->{"program"}->[$layer->{"fltevent"}]->[4];

			my $params = FloatParams(($msec-$msecstart) / ($msecend-$msecstart), $paramstart, $paramend);

			my %pcopy = %{$params};
			$self->{"program"}->[$layer->{"fltevent"}]->[6] = \%pcopy;
#			print "prev " . $layer->{"fltevent"} . " " . join(",", %pcopy) . "\n";
		
			$layer->{"engine"}->SetParams($params);
		}
	}

	logstr( "Renderloop: (" . @{$self->{"layers"}} . " layers):\n" );
	# Render all the layers in ascending order
	foreach $layer (sort { $a->{"depth"} <=> $b->{"depth"} } @{$self->{"layers"}}) {

		my $reltime = $msec - $self->{"program"}->[$layer->{"startevent"}]->[0];

		$layer->{"engine"}->Render($reltime);
	}
	logstr( "\n" );

	$self->{"curevent"} = $curevent;

	return 0;
}

sub AddLayer($$$$) {
	my ($self, $engine, $name, $depth, $event) = @_;

	my $newlayer;
	logstr( "Add Layer\n" );

	$newlayer->{"engine"} = $engine;
	$newlayer->{"name"} = $name;
	$newlayer->{"depth"} = $depth;
	$newlayer->{"startevent"} = $event;
	$newlayer->{"curevent"} = $event;

	push @{$self->{"layers"}}, $newlayer;
}

sub RemoveLayer($$) {
	my ($self, $name) = @_;

	my $layer;

	@{$self->{"layers"}} = grep { $_->{"name"} ne $name } @{$self->{"layers"}};
}

sub SetLayer($$$) {
	my ($self, $name, $params) = @_;

	# Find the correct layer
	foreach $layer (@{$self->{"layers"}}) {
		if($layer->{"name"} eq $name) {
			$layer->{"engine"}->SetParams($params);
		}
	}
}
sub FloatLayer($$$) {
	my ($self, $name, $fltevent) = @_;

	my $layer;

	# Find the correct layer
	foreach $layer (@{$self->{"layers"}}) {
		if($layer->{"name"} eq $name) {
			if(defined($layer->{"fltevent"})) {
				$layer->{"curevent"} = $layer->{"fltevent"};
			}
			if($fltevent == 0) {
				# turn off float
				undef($layer->{"fltevent"});
				$layer->{"engine"}->SetParams($self->{"program"}->[$layer->{"curevent"}]->[4]);
			} else {
				$layer->{"fltevent"} = $fltevent;
			}
		}
	}
}

sub LoadProgram($$) {
	my ($self, $program) = @_;

	logstr( "Loading program, (" . (0 + @{$program}) . " events)\n" );
	# Copy program
	my @program= @{$program};

	# Sort by start moment
	@program = sort { $a->[0] <=> $b->[0] } @program;

	$self->{"program"} = \@program;
}

sub FindNextFlt($$$) {
	my ($self, $first, $name) = @_;

	$first++;
	while($first < @{$self->{"program"}}) {
		if($self->{"program"}->[$first]->[3] eq $name) {
			if($self->{"program"}->[$first]->[1] == FLT) {
				return $first;
			} else {
				return;
			}
		}
		$first++;
	}

	return;
}

sub FloatParams($$$) {
	my ($n, $p1, $p2) = @_;
	my $key;
	my %output = %{$p1};

	my @sharedkeys;

	@sharedkeys = grep { $a = $_; grep { $_ eq $a } keys %{$p2} } keys %{$p1};

	foreach $key (@sharedkeys) {
		if(is_numeric($p1->{$key}) && is_numeric($p2->{$key})) {
			$output{$key} = $n * ($p2->{$key} - $p1->{$key}) + $p1->{$key};
		}
	}

	return \%output;
}

1;