struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

float V_Alpha;

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float4 PS(VS_OUTPUT In) : COLOR0
{
  float4 color;
  color.rgb = 0.4;
  color    -= tex2D( base_map, In.Tex0.xy-0.0025)*2.0;
  color    += tex2D( base_map, In.Tex0.xy+0.0025)*2.0;
  color     = (color.r+color.g+color.b)/3.0;
  color.a   = V_Alpha;
  return color;
}

//--------------------------------------------------------------//
// Technique Section for Procedural Graphic Effects 2D
//--------------------------------------------------------------//
technique Additive
{
  pass PassAdditive
  {
    PixelShader = compile ps_2_0 PS();
  }
}
