struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

float4x4 WorldViewProjection : WORLDVIEWPROJECTION;
float V_Alpha : ALPHA;

sampler textura : register(s0);
sampler env : register(s1);

VS_OUTPUT VS(float3 inPos : POSITION, float2 inTex : TEXCOORD0)
{
  VS_OUTPUT Out;
  Out.Position = mul(float4(inPos,1), WorldViewProjection);
  Out.Tex0 = float3(inTex, 1);
  return Out;
}

float4 PS(VS_OUTPUT In) : COLOR0
{
  float4 Color = tex2D(textura, In.Tex0);
  float4 C2 = tex2D(env, In.Tex0);
  Color.a = V_Alpha * Color.a;
  return Color + C2;
}

technique Emboss
{
  pass PassEmboss
  {
    VertexShader = compile vs_1_1 VS();
    PixelShader = compile ps_1_4 PS();
  }
}
