/*  Tools
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef PTEXT_H
#define PTEXT_H

#include "common.h"
#include "pchar.h"

namespace Tools
{
	class PText {
	public:
		PText();
		~PText();
		void Draw(float move, float r, float g, float b, int spacing, const char* pText, bool solid);
	private:
		void DrawCharacter(const char* pIdentity, float move, float r, float g, float b, bool solid);
		std::map<std::string, PChar*> m_AlphaList;
	};		
}

#endif
