/*  Tools
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#include "ptext.h"
#include "random.h"
#include "../ds/mmodel.h"

using namespace std;

namespace Tools
{
	PText::PText()
	{
		// Load characters
		string ch;
		for(int i = 65; i < 90+1; i++) {
			ch = (char)i;
			m_AlphaList[ch] = new PChar(ch.c_str());
		}

		for(int i = 48; i < 57+1; i++) {
			ch = (char)i;
			m_AlphaList[ch] = new PChar(ch.c_str());
		}
		
		m_AlphaList["AR"] = new PChar("AR");//Å
		m_AlphaList["AD"] = new PChar("AD");//Ä
		m_AlphaList["OD"] = new PChar("OD");//Ö
		m_AlphaList["QM"] = new PChar("QM");//?
		m_AlphaList["LI"] = new PChar("LI");//-
		m_AlphaList["AS"] = new PChar("AS");//*
		m_AlphaList["SC"] = new PChar("SC");//;
		m_AlphaList["CO"] = new PChar("CO");//:
		m_AlphaList["AT"] = new PChar("AT");//@
		m_AlphaList["DT"] = new PChar("DT");//.
		m_AlphaList["CM"] = new PChar("CM");//,
		m_AlphaList["QU"] = new PChar("QU");//"
		m_AlphaList["PL"] = new PChar("PL");//+
		m_AlphaList["AN"] = new PChar("AN");//&
		m_AlphaList["EX"] = new PChar("EX");//!
		m_AlphaList["DI"] = new PChar("DI");///
		m_AlphaList["LP"] = new PChar("LP");//(
		m_AlphaList["RP"] = new PChar("RP");//)
		m_AlphaList["UN"] = new PChar("UN");//_
	}
	
	PText::~PText()
	{
		if(m_AlphaList.size() > 0)
		{			
			std::map <std::string, PChar*>::iterator iter = m_AlphaList.begin();
			while(iter != m_AlphaList.end())
			{
				delete iter->second;
				++iter;
			}
		}
	}
	
	void PText::DrawCharacter(const char* pIdentity, float move, float r, float g, float b, bool solid)
	{
		if(solid) {
			glColor3f(r, g, b);
			DS::MModel::GetPointer()->GetModel(pIdentity)->Draw();
		}
		else
			m_AlphaList[pIdentity]->Draw(move, (r+g+b)/3);		
	}
	
	void PText::Draw(float move, float r, float g, float b, int spacing, const char *pText, bool solid)
	{
		string text = pText;
		string ch;
		
		// Center text
		glTranslatef(-(((int)text.size()/2)*spacing-(spacing/2)), 0, 0);
		
		glPushMatrix();
			for(int i = 0; i < (int)text.size(); i++)
			{
				ch = text[i];
				switch(text[i])
				{
				case '<':
					DrawCharacter("AR", move, r, g, b, solid);
					break;
				case '>':
					DrawCharacter("AD", move, r, g, b, solid);
					break;
				case '|':
					DrawCharacter("OD", move, r, g, b, solid);
					break;
				case '?':
					DrawCharacter("QM", move, r, g, b, solid);
					break;
				case '-':
					DrawCharacter("LI", move, r, g, b, solid);
					break;
				case '*':
					DrawCharacter("AS", move, r, g, b, solid);
					break;
				case '@':
					DrawCharacter("AT", move, r, g, b, solid);
					break;
				case ';':
					DrawCharacter("SC", move, r, g, b, solid);
					break;
				case ':':
					DrawCharacter("CO", move, r, g, b, solid);
					break;
				case '.':
					DrawCharacter("DT", move, r, g, b, solid);
					break;
				case ',':
					DrawCharacter("CM", move, r, g, b, solid);
					break;
				case '\"':
					DrawCharacter("QU", move, r, g, b, solid);
					break;
				case '+':
					DrawCharacter("PL", move, r, g, b, solid);
					break;
				case '&':
					DrawCharacter("AN", move, r, g, b, solid);
					break;
				case '!':
					DrawCharacter("EX", move, r, g, b, solid);
					break;					
				case '/':
					DrawCharacter("DI", move, r, g, b, solid);
					break;					
				case '(':
					DrawCharacter("LP", move, r, g, b, solid);
					break;					
				case ')':
					DrawCharacter("RP", move, r, g, b, solid);
					break;
				case '_':
					DrawCharacter("UN", move, r, g, b, solid);
					break;				
				case ' ':
					break;					
				default:
					DrawCharacter(ch.c_str(), move, r, g, b, solid);
					break;
				}
				
				glTranslatef(spacing, 0, 0);
			}
		glPopMatrix();
	}
}
