/*  Tools
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#include "prect.h"
#include "random.h"
#include "../ds/mtexture.h"

using namespace std;

namespace Tools
{
	PRect::PRect(int nParts, float width, float height, int nOld)
	{
		m_nParticles = nParts;
		m_pParticles = new Particle[nParts];
		
		for(int i = 0; i < m_nParticles; i++)
		{
			Particle* p = &m_pParticles[i];
			p->life = 1;
			p->fade = Random()/10 + 0.03;
			p->active = true;
			p->xd = URandom();
			p->yd = URandom();
			//p->r = 1;//Random();
			//p->g = Random();
			p->b = Random();
			//p->yg = 0.05;
		}
	
		int nHParts = (int)((float)m_nParticles/((width+height)/height));
		int nVParts = m_nParticles - nHParts;
		
		// Vertical particles
		for(int i = 0; i < nVParts/2; i++) // Top
		{
			Particle* p = &m_pParticles[i];
			p->y = p->sy = (height/2);
			p->x = p->sx = -(width/2) + (width*((float)i/(nVParts/2)));
		}
		
		for(int i = nVParts/2; i < nVParts; i++) // Bottom
		{
			Particle* p = &m_pParticles[i];
			p->y = p->sy = -(height/2);
			p->x = p->sx = -(width/2) + (width*((float)(i-nVParts/2)/(nVParts/2)));
		}		
		
		// Horizontal particles
		for(int i = nVParts; i < nVParts+nHParts/2; i++) // Left
		{
			Particle* p = &m_pParticles[i];
			p->x = p->sx = -(width/2);
			p->y = p->sy = -(height/2) + (height*((float)(i-nVParts)/(nHParts/2)));
		}	
		
		for(int i = nVParts+(nHParts/2); i < nVParts+nHParts; i++) // Right
		{
			Particle* p = &m_pParticles[i];
			p->x = p->sx = (width/2);
			p->y = p->sy = -(height/2) + (height*((float)(i-nVParts-(nHParts/2))/(nHParts/2)));
		}	
		
		m_nOld = nOld;
	}
	
	PRect::~PRect()
	{
		delete m_pParticles;
	}
	
	void PRect::Draw(float move, float intensity, float life)
	{
		static GLuint texture = DS::MTexture::GetPointer()->GetTexture("fuzzy");
		
		for(int i = 0; i < m_nParticles; i++)
		{
			float life = m_pParticles[i].life;
			glColor3f(m_pParticles[i].r*life*intensity, m_pParticles[i].g*life*intensity, m_pParticles[i].b*life*intensity);
			glPushMatrix();
				glTranslatef(m_pParticles[i].x, m_pParticles[i].y, m_pParticles[i].z);	
				glBindTexture(GL_TEXTURE_2D, texture);
				glScalef(0.05, 0.05, 1);
				glBegin(GL_QUADS);
					glTexCoord2f(1.0f, 1.0f); 
					glVertex3f(-1, -1, 0);
					glTexCoord2f(1.0f, 0.0f);
					glVertex3f(-1, 1, 0);
					glTexCoord2f(0.0f, 0.0f);
					glVertex3f(1, 1, 0);
					glTexCoord2f(0.0f, 1.0f);
					glVertex3f(1, -1, 0);
				glEnd();		
			glPopMatrix();
			
			// "Tail"
			for(int j = 0; j < m_nOld; j++)
			{
				glPushMatrix();
				glTranslatef(m_pParticles[i].oldx[j], m_pParticles[i].oldy[j], m_pParticles[i].oldz[j]);	
				glBindTexture(GL_TEXTURE_2D, texture);
				glScalef(0.01, 0.01, 1);
				glBegin(GL_QUADS);
					glTexCoord2f(1.0f, 1.0f); 
					glVertex3f(-1, -1, 0);
					glTexCoord2f(1.0f, 0.0f);
					glVertex3f(-1, 1, 0);
					glTexCoord2f(0.0f, 0.0f);
					glVertex3f(1, 1, 0);
					glTexCoord2f(0.0f, 1.0f);
					glVertex3f(1, -1, 0);
				glEnd();		
				glPopMatrix();				
			}
			
		}	
				
		Update(1, 1, 0, move, 0.01, life);
	}
}
