/*  Tools
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#include "pchar.h"
#include "random.h"
#include "../ds/mtexture.h"
#include "../ds/mmodel.h"

using namespace std;

namespace Tools
{
	PChar::PChar(const char* pIdentity)
	{
		DS::Model* pModel = DS::MModel::GetPointer()->GetModel(pIdentity);
		
		m_nParticles = pModel->m_nVertices;
		m_pParticles = new Particle[m_nParticles];
		
		for(int i = 0; i < m_nParticles; i++)
		{
			Particle* p = &m_pParticles[i];
			p->life = 1;
			p->fade = Random()/10 + 0.03;
			p->active = true;
			p->x = p->sx = pModel->m_pVertices[i].position[0];
			p->y = p->sy = pModel->m_pVertices[i].position[1];
			p->z = p->sz = pModel->m_pVertices[i].position[2];
			p->xd = URandom();
			p->yd = URandom();
			p->zd = URandom();
			p->r = p->g = p->b = 1;
			//p->r = 1;//Random();
			//p->g = Random();
			//p->b = Random();
			//p->yg = 0.05;
		}
	}
	
	PChar::~PChar()
	{
		delete m_pParticles;
	}
	
	void PChar::Draw(float move, float intensity)
	{
		static GLuint texture = DS::MTexture::GetPointer()->GetTexture("fuzzy");

		for(int i = 0; i < m_nParticles; i++)
		{
			float life = m_pParticles[i].life;
			glColor3f(m_pParticles[i].r*life*intensity, m_pParticles[i].g*life*intensity, m_pParticles[i].b*life*intensity);
			glPushMatrix();
				glTranslatef(m_pParticles[i].x, m_pParticles[i].y, m_pParticles[i].z);	
				glBindTexture(GL_TEXTURE_2D, texture);
				glScalef(0.3, 0.3, 0.3);
				glBegin(GL_QUADS);
					glTexCoord2f(1.0f, 1.0f); 
					glVertex3f(-1, -1, 0);
					glTexCoord2f(1.0f, 0.0f);
					glVertex3f(-1, 1, 0);
					glTexCoord2f(0.0f, 0.0f);
					glVertex3f(1, 1, 0);
					glTexCoord2f(0.0f, 1.0f);
					glVertex3f(1, -1, 0);
				glEnd();		
				/*glRotatef(90, 1, 0, 0);
				glBegin(GL_QUADS);
					glTexCoord2f(1.0f, 1.0f); 
					glVertex3f(-1, -1, 0);
					glTexCoord2f(1.0f, 0.0f);
					glVertex3f(-1, 1, 0);
					glTexCoord2f(0.0f, 0.0f);
					glVertex3f(1, 1, 0);
					glTexCoord2f(0.0f, 1.0f);
					glVertex3f(1, -1, 0);
				glEnd();		
				glRotatef(90, 0, 1, 0);
				glBegin(GL_QUADS);
					glTexCoord2f(1.0f, 1.0f); 
					glVertex3f(-1, -1, 0);
					glTexCoord2f(1.0f, 0.0f);
					glVertex3f(-1, 1, 0);
					glTexCoord2f(0.0f, 0.0f);
					glVertex3f(1, 1, 0);
					glTexCoord2f(0.0f, 1.0f);
					glVertex3f(1, -1, 0);
				glEnd();		*/
			glPopMatrix();
		}	
			
		/*static float muff = 0;
		if(muff >= 0.3)
			muff = 0;
		if(muff <= 0.03)
			muff += 0.00005*move;
		else
			muff += 0.0003*move;*/
		Update(1, 1, 0, move, 0, 1);
	}
}
