/*  Tools
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#include "mxmodel.h"
#include "random.h"
#include "quad.h"
#include "../ds/mtexture.h"
#include "../ds/mmodel.h"
#include <sstream>

using namespace std;

namespace Tools
{	
	MxModel::MxModel(const char* pIdentity)
	{
		DS::Model* pModel = DS::MModel::GetPointer()->GetModel(pIdentity);
		
		m_nItems = pModel->m_nVertices;
		m_pItems = new MC[m_nItems];
		
		int blue = 0;
		for(int i = 0; i < m_nItems; i++)
		{
			MC* m = &m_pItems[i];
			m->x = pModel->m_pVertices[i].position[0];
			m->y = pModel->m_pVertices[i].position[1];
			m->z = pModel->m_pVertices[i].position[2];
			m->r = 0;
			if(blue++ == 10) {
				blue = 0;
				m->g = 0.5;
				m->b = 1;
			}
			else {
				m->g = 1;
				m->b = 0.5;
			}
		}		
	}
	
	MxModel::~MxModel()
	{
		delete m_pItems;
	}
	
	void MxModel::InitGL()
	{
		DS::MTexture* pT = DS::MTexture::GetPointer();
		for(int i = 0; i < m_nItems; i++)
		{
			stringstream ss; ss << (int)((float)Random()*34);
			m_pItems[i].texture = pT->GetTexture(((string)"mx" + ss.str()).c_str());
		}
	}

	void MxModel::Draw(float move, float intensity, float detail)
	{		
		glScalef(0.1, 0.1, 0.1);
		glPushMatrix();
		for(int i = 0; i < m_nItems; i+=(int)((float)1/detail))
		{	
			glPushMatrix();
				glColor3f(m_pItems[i].r*intensity, m_pItems[i].g*intensity,
					m_pItems[i].b*intensity);
				glTranslatef(m_pItems[i].x, m_pItems[i].y, m_pItems[i].z);
				glBindTexture(GL_TEXTURE_2D, m_pItems[i].texture);
				DrawQuad(1, 1);
				glRotatef(90, 0, 1, 0);
				DrawQuad(1, 1);
			glPopMatrix();
		}
		glPopMatrix();
	}
}
