/*  Tools
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef MATRIX_H
#define MATRIX_H

#include "common.h"

namespace Tools
{
	class MxString {
	public:
		MxString(int maxlen);
		void InitTextures();
		void Move();

		std::vector<GLuint> parts;
		int len;
		int pos;
		bool active;
	private:
		int m_nRows;
	};
	
	class MxCollumn {
	public:
		MxCollumn(int rows);
		~MxCollumn();
		void Init();
		void StartString();
		void Update();
		void Draw(float move, float intensity);
		MxString* pS0;
		MxString* pS1;
		int m_nRows;
	};
	
	class Matrix {
	public:
		Matrix(int rows, int cols);
		~Matrix();
		void Draw(float move, float intensity);
		void InitGL();
	private:
		std::vector<MxCollumn*> m_cols;
		int m_nCols;
		int m_nRows;
	};		
}

#endif
