/*  Tools
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#include "matrix.h"
#include "random.h"
#include "quad.h"
#include "../ds/mtexture.h"
#include <sstream>

using namespace std;

namespace Tools
{

	MxString::MxString(int rows)
	{
		m_nRows = rows;
		pos = -1;
		len = 1 + (int)((float)Random()*(rows-2));
		active = false;
	}
	
	void MxString::InitTextures()
	{
		DS::MTexture* pT = DS::MTexture::GetPointer();
		for(int i = 0; i < len; i++)
		{
			stringstream ss; ss << (int)((float)Random()*34);
			GLuint texture = pT->GetTexture(((string)"mx" + ss.str()).c_str());
			parts.push_back(texture);
		}
	}
	
	void MxString::Move()
	{
		pos++;
		if((pos - len) == m_nRows)
		{
			pos = -1;
			active = false;
		}
	}

	MxCollumn::MxCollumn(int rows)
	{
		m_nRows = rows;
		pS0 = new MxString(rows);
		pS1 = new MxString(rows);
	}
	
	MxCollumn::~MxCollumn()
	{
		delete pS0;
		delete pS1;
	}
	
	void MxCollumn::StartString()
	{
		if(!pS0->active)
		{
			pS0->active = true;
			if(pS1->active && (pS1->pos - pS1->len) < 1)
				pS0->active = false;
		}

		if(!pS1->active)
		{
			pS1->active = true;
			if(pS0->active && (pS0->pos - pS0->len) < 1)
				pS1->active = false;
		}
		
		//if(!pS0->active)
			//pS0->active = true;
	}
	
	void MxCollumn::Update()
	{
		if(pS0->active)
			pS0->Move();
		if(pS1->active)
			pS1->Move();
	}
	
	void MxCollumn::Init()
	{
		pS0->InitTextures();
		pS1->InitTextures();
	}
	
	void MxCollumn::Draw(float move, float intensity)
	{
		if(pS0->active)
		{
			glPushMatrix();
			glTranslatef(0, -pS0->pos*0.2, 0);
			glPushMatrix();
				for(int j = 0; j < pS0->len; j++)
				{			
					glTranslatef(0, 0.2, 0);
					glPushMatrix();
					static float spin = 0;
					spin += 0.01*move;
					//glRotatef(j%2*spin, 1, 1, 1);
					if((pS0->pos - j) >= 0 &&
						(pS0->pos - j) < m_nRows)
					{
						if(!j)
							glColor3f(0, intensity*1, intensity*0.5);
						else
							glColor3f(0, intensity*0.6, intensity*0.2);
						glBindTexture(GL_TEXTURE_2D, pS0->parts[j]);
						DrawQuad(0.2, 0.2);
						glRotatef(90, 0, 1, 0);
						DrawQuad(0.2, 0.2);
					}
					glPopMatrix();
				}
			glPopMatrix();
			glPopMatrix();
		}
		
		if(pS1->active)
		{
			glPushMatrix();
			glTranslatef(0, -pS1->pos*0.2, 0);
			glPushMatrix();
				for(int j = 0; j < pS1->len; j++)
				{		
					glTranslatef(0, 0.2, 0);
					glPushMatrix();
					static float spin = 0;
					spin += 0.01*move;
					glRotatef(j%2*spin, 1, 1, 1);
					if((pS1->pos - j) >= 0 &&
						(pS1->pos - j) < m_nRows)
					{
						if(!j)
							glColor3f(0, intensity*0.5, intensity*1);
						else
							glColor3f(0, intensity*0.2, intensity*0.6);
						glBindTexture(GL_TEXTURE_2D, pS1->parts[j]);
						DrawQuad(0.2, 0.2);
						glRotatef(90, 0, 1, 0);
						DrawQuad(0.2, 0.2);
					}
					glPopMatrix();
				}
			glPopMatrix();
			glPopMatrix();
		}

	}
	
	Matrix::Matrix(int rows, int cols)
	{
		m_nRows = rows;
		m_nCols = cols;
		
		for(int i = 0; i < m_nCols; i++)
		{
			MxCollumn* pC = new MxCollumn(m_nRows);
			m_cols.push_back(pC);
		}
	}
	
	Matrix::~Matrix()
	{
		for(int i = 0; i < m_nCols; i++)
			delete m_cols[i];
	}
	
	void Matrix::InitGL()
	{
		for(int i = 0; i < m_nCols; i++)
			m_cols[i]->Init();
	}

	void Matrix::Draw(float move, float intensity)
	{
		static float tick = 0;
		tick += 0.7*move;
		if(tick >= 1) {
			m_cols[(int)((float)Random()*m_nCols)]->StartString();
			//m_cols[0]->StartString();
			for(int i = 0; i < m_nCols; i++) {
				//m_cols[i]->StartString();
				m_cols[i]->Update();
			}
			tick = 0;
		}	
		
		glEnable(GL_TEXTURE_2D);
		glEnable(GL_BLEND);
		glPushMatrix();
			glTranslatef(-(m_nCols/2)*0.2, (m_nRows/2)*0.2, 0);
			for(int i = 0; i < m_nCols; i++)
			{	
				glPushMatrix();
					glTranslatef(i*0.2, 0, 0);
					m_cols[i]->Draw(move, intensity);
				glPopMatrix();		
			}
		glPopMatrix();
		glDisable(GL_BLEND);
		glDisable(GL_TEXTURE_2D);
	}
}
