/*  xa-004: Beatbox invitro 
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#include "scene5.h"
#include <vector>

using namespace std;

// Scene end time
#define END 13800

namespace Scene
{			
	Scene5::~Scene5()
	{
		delete m_pText;
	}
	
	void Scene5::EnterScene()
	{	
		glShadeModel(GL_SMOOTH);
		glEnable(GL_DEPTH_TEST);
		glDepthFunc(GL_LEQUAL);
		
		glClearDepth(1);
		glClearColor(0.0, 0.0, 0.0, 0);
		glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		
		GLfloat ratio = (GLfloat)4/3;
		glViewport(0, 0, m_pMVideo->GetWidth(), m_pMVideo->GetHeight());
		
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(45, ratio, 1, 100);
    
    	glMatrixMode(GL_MODELVIEW);
    	glLoadIdentity();
		
		m_pMatrix->InitGL();
	} 
	
	int Scene5::LoadScene()
	{	
#ifdef DEBUG
		m_identity = "Creators";
#endif
		m_pMatrix = new Tools::Matrix(20, 20);
		m_pText = new Tools::PText;
		return 0;
	} 
	
	int Scene5::DrawFrame(long time, float move)
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glLoadIdentity();
		
		static float fadeout = 1;
		EVENT(END-2000, END)
		{
			if(fadeout > 0)
				Change(fadeout, move, -0.5);
			else
				fadeout = 0;
		}
			
		glTranslatef(0, 0, -10);
		
		static float model = 0;
		if(model < 1)
			Change(model, move, 4);
		else
			Change(model, move, 10);
		
		if(model >= 2)
			model = 0;
		
		static float bounce = 0;
		Change(bounce, move, M_PI);
		if(bounce >= M_PI)
			bounce = 0;
		
		static float wave = 0;
		Change(wave, move, M_PI/4);
		if(wave >= M_PI*2)
			wave = 0;
		
		static float rotate = 0;
		Change(rotate, move, 90);
		if(rotate == 360)
			rotate = 0;
		
		glEnable(GL_TEXTURE_2D);	
		glPushMatrix();
				static DS::Model* pModels[] = {
					DS::MModel::GetPointer()->GetModel("bbox01"),
					DS::MModel::GetPointer()->GetModel("bbox02")};
			
				glColor3f(fadeout, fadeout, fadeout);
				glPushMatrix();
					glTranslatef(sin(wave)*8, sin(bounce) - 4.3, -10);
					glScalef(0.04, 0.04, 0.04);
					glRotatef(rotate, 1, 1, 1);
					pModels[(int)model]->Draw();
				glPopMatrix();
		glPopMatrix();		
		glDisable(GL_TEXTURE_2D);
							
		glPushMatrix();			
			glTranslatef(sin(wave)*8, sin(bounce) - 2.3, -5);
			glScalef(0.05, 0.05, 0.05);
			m_pText->Draw(move, fadeout, fadeout, fadeout, 7, "3D: DANTER", true);					
		glPopMatrix();
		
		glPushMatrix();					
			glTranslatef(-6, 4, -6);
			m_pMatrix->Draw(move, fadeout);								
		glPopMatrix();
					
		glPushMatrix();
			glTranslatef(-6, 4, -5);
			glScalef(0.05, 0.05, 0.05);
			m_pText->Draw(move, fadeout, fadeout, fadeout, 7, "CODE: TREJS", true);
		glPopMatrix();
		
		glEnable(GL_TEXTURE_2D);
		glPushMatrix();
			glTranslatef(5, 4, -5);
			glRotatef(sin(wave)*16, 0, 0, 1);
			static GLuint texture = DS::MTexture::GetPointer()->GetTexture("twodee");
			glBindTexture(GL_TEXTURE_2D, texture);	
			Tools::DrawQuad(4, 4);
		glPopMatrix();
		glDisable(GL_TEXTURE_2D);
		
		glPushMatrix();
			glTranslatef(5, 4, -5);
			glScalef(0.05, 0.05, 0.05);
			m_pText->Draw(move, fadeout, fadeout, fadeout, 7, "2D: TREJS & DANTER", true);					
		glPopMatrix();
		
		glPushMatrix();
			glTranslatef(0, 1, -10);
			glColor3f(fadeout, 0, 0);
			glRotatef(sin(wave)*16, 0, 0, 1);
			static DS::Model* pModel = DS::MModel::GetPointer()->GetModel("note");
			glScalef(0.07, 0.07, 0.07);
			pModel->Draw();
		glPopMatrix();

		glPushMatrix();
			glTranslatef(0, 1, -5);
			glScalef(0.05, 0.05, 0.05);
			m_pText->Draw(move, fadeout, fadeout, fadeout, 7, "MUSIC: ALGAR/TJC", true);					
		glPopMatrix();
		
		glPushMatrix();
			glTranslatef(-0.5, -5.7	, -5);
			glScalef(0.07, 0.07, 0.07);
			m_pText->Draw(move, fadeout, fadeout, fadeout, 10, "HTTP://BEATBOX.TJC.SE", true);					
		glPopMatrix();

		if(time >= END)
			return END_SCENE;
		else
			return CONTINUE;
	}
}
