/*  xa-004: Beatbox invitro 
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#include "scene3.h"
#include <vector>

using namespace std;

// Scene end time
#define END 34100

namespace Scene
{			
	Scene3::~Scene3()
	{
		delete m_pText;
		delete m_pMatrix;
	}
	
	void Scene3::EnterScene()
	{	
		glShadeModel(GL_SMOOTH);
		glEnable(GL_DEPTH_TEST);
		glDepthFunc(GL_LEQUAL);
		
		glClearDepth(1);
		glClearColor(0.0, 0.0, 0.0, 0);
		glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
		//glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		
		GLfloat ratio = (GLfloat)4/3;
		glViewport(0, 0, m_pMVideo->GetWidth(), m_pMVideo->GetHeight());
		
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(45, ratio, 1, 100);
    
    	glMatrixMode(GL_MODELVIEW);
    	glLoadIdentity();	

		m_pMatrix->InitGL();
				
	} 
	
	int Scene3::LoadScene()
	{	
#ifdef DEBUG
		m_identity = "Greets";
#endif
		
		m_texts.push_back("DEADLINE 2007");
		m_texts.push_back("ODIOUS");
		m_texts.push_back("APPROXIMATE");
		m_texts.push_back("FAIRLIGHT");
		m_texts.push_back("ILLUMINATI");
		m_texts.push_back("HYPERCUBE");
		m_texts.push_back("TMD CREW");
		m_texts.push_back("OUTBREAK");

		
		m_pMatrix = new Tools::Matrix(125, 20);
		m_pText = new Tools::PText;
		return 0;
	} 
	
	int Scene3::DrawFrame(long time, float move)
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glLoadIdentity();
		
		glTranslatef(0, 0, -10);
		static float movein = 1;
		EVENT(END-10000, END)
		{
			static float blackout = 1;
			EVENT(END-1000, END)
			{
				if(blackout > 0)
					Change(blackout, move, -1);
				else
					blackout = 0;
			}

			if(movein > 0)
				Change(movein, move, -0.25);
			else
				movein = 0;
			
			static float rotate_room = 90;
			Change(rotate_room, move, 30);	
			glPushMatrix();
				glEnable(GL_TEXTURE_2D);
				glEnable(GL_BLEND);
				glRotatef(rotate_room, 0, 1, 0);
				static Tools::MxModel mxmodel("throneroom_v2");
				static bool temp = false;
				if(!temp)
				{
					temp = true;
					mxmodel.InitGL();
				}
				glTranslatef(0, -5, movein*100);
				mxmodel.Draw(move, (1-movein)*blackout*1, 0.25);
				glDisable(GL_TEXTURE_2D);
				glDisable(GL_BLEND);
			glPopMatrix();
		}
	
		EVENT(0, END-5000)
		{
		glPushMatrix();
			static float blackout_matrix = 1;
			EVENT(END-10000, END-8000)
			{
				if(blackout_matrix > 0)
					Change(blackout_matrix, move, -0.5);
				else
					blackout_matrix = 0;
			}
			
			glRotatef(-87, 1, 0, 0);
			glTranslatef(0, -10, 0);
			glScalef(0.5, 0.5, 0.5);			
			m_pMatrix->Draw(move, blackout_matrix);
		glPopMatrix();
		}
		
		EVENT(5000, 9000)
		{
			static float mo = 0;
			Change(mo, move, 0.25);
			
			glPushMatrix();
				glTranslatef(0, 1, 10 - 200*mo);	
				glPushMatrix();
					glScalef(0.15, 0.15, 0.15);
					//glTranslatef(-(((int)6/2)*10-(10/2)), 0, 0);
					m_pText->Draw(move, 1*(1-mo), 1*(1-mo), 0, 7, "WE SAY HELLO TO...", true);
				glPopMatrix();
			glPopMatrix();
		}
		
		static int t = 0;
		//EVENT(7200, END)
		EVENT(6686, END)
		{
			static float bounce = 0.001;
			if(bounce < M_PI && bounce > 0)
				Change(bounce, move, 0.5*M_PI);//M_PI*0.29*2);
			else {
				bounce = 0.001;
				t++;
			}
			float scale = sin(bounce);
					
			glPushMatrix();
				glTranslatef(0, 1, 0);	
				glScalef(scale, scale, scale);
				glPushMatrix();
					glScalef(0.15, 0.15, 0.15);
					//glTranslatef(-(((int)6/2)*10-(10/2)), 0, 0);
					if(t < 8)
						m_pText->Draw(move, 1, 1, 0, 7, m_texts[t].c_str(), true);
				glPopMatrix();
			glPopMatrix();
		}
					
		if(time >= END)
			return END_SCENE;
		else
			return CONTINUE;
	}
}
