/*  xa-004: Beatbox invitro 
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#include "intro.h"
#include "png.h"

using namespace std;

// Scene end time
#define END 13650

namespace Scene
{			
	int Intro::LoadScene()
	{
#ifdef DEBUG
		m_identity = "Intro";
#endif
		
		return 0;
	}
	
	Intro::~Intro()
	{

	}
	
	void Intro::EnterScene()
	{
		glShadeModel(GL_SMOOTH);
		glEnable(GL_DEPTH_TEST);
		glDepthFunc(GL_LEQUAL);
		
		glClearDepth(1);
		glClearColor(0.0, 0.0, 0.0, 0);
		glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		
		GLfloat ratio = (GLfloat)4/3;
		glViewport(0, 0, m_pMVideo->GetWidth(), m_pMVideo->GetHeight());
		
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(45, ratio, 1, 100);
    
    	glMatrixMode(GL_MODELVIEW);
    	glLoadIdentity();
				
		DS::MMusic::GetPointer()->Play("bxinv3", false);
		//DS::MMusic::GetPointer()->Play("bx.ogg", false);
	} 
			
	int Intro::DrawFrame(long time, float move)
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glLoadIdentity();
		
		// Intro text ----------------------------------------------------------
		static float moveout = 0;
		
		EVENT(END-1000, END)
		{
			if(moveout < 1)
				Change(moveout, move, 1);
			else
				moveout = 1;
		}
			
		
		glTranslatef(0,  0, -10 - moveout*100);
		glRotatef(360*sin(-moveout*4), 1, 1, 1);
		
		glEnable(GL_TEXTURE_2D);
		glEnable(GL_BLEND);

			
		static int text0_total = 12;
		static int text1_total = 17;
		static int text0_ldata[] = { 33, 44, 37, 38, 16, 34, 16, 44, 12,
										39, 32, 44 };
		static int text1_ldata[] = { 12, 38, 36, 14, 20, 36, 32, 16, 34,
										36, 36, 18, 22, 34, 19, 16, 16 };
		
		// Frame fadein
		static float fadein_frame = 0;
		EVENT(0, 1500)
		{
			if(fadein_frame >= 1)
				fadein_frame = 1;
			else
				Change(fadein_frame, move, 0.75);
		}
		
		// Frame moveout
		static float moveout_frame = 1;
		EVENT(1100, 2100)
		{
			if(moveout_frame <= 0)
				moveout_frame = 0;
			else
				Change(moveout_frame, move, -1);
		}
		
		// Blink before text is written
		static bool blink_active = false;
		EVENT(3300, 5000)
		{
			blink_active = true;
		}
		
		// Write xAngle & TJC
		static int line = 0;
		static float current_letter = 0;
		static float line0_pos;
		EVENT(6900, 9500)
		{
			blink_active = false;
			if(current_letter <= text0_total)
				Change(current_letter, move, 8);
			else
				current_letter = text0_total;
			
			line0_pos = 0;
			for(int i = 0; i < (int)current_letter; i++)
				line0_pos += (float)0.01*text0_ldata[i];
		}
		
		static float line1_pos;
		EVENT(9500, 12000)
		{
			if(!line)
			{
				line = 1;
				current_letter = 0;
			}
			
			blink_active = false;
			if(current_letter <= text1_total)
				Change(current_letter, move, 8);
			else
				current_letter = text1_total;
			
			line1_pos = 0;
			for(int i = 0; i < (int)current_letter; i++)
				line1_pos += (float)0.01*text1_ldata[i];
		}
		
		EVENT(11700, END)
		{
			blink_active = true;
		}
		
		// Frame
		glColor3f(fadein_frame, fadein_frame, fadein_frame);
		static GLuint frame = DS::MTexture::GetPointer()->GetTexture("intro_frame");
		glBindTexture(GL_TEXTURE_2D, frame);
		glPushMatrix();
			glTranslatef(-2.56 + (2.56 - 0.08)*moveout_frame, 0.64 - 0.48*moveout_frame, 0);
			Tools::DrawQuad(0.64, 0.64);
		glPopMatrix();
		glPushMatrix();
			glTranslatef(2.56 - (2.56 - 0.08)*moveout_frame, -0.64 + 0.48*moveout_frame, 0);
			glRotatef(180, 0, 0, 1);
			Tools::DrawQuad(0.64, 0.64);
		glPopMatrix();
				EVENT(3300, END)
		{				
			// Text: Line0
			glPushMatrix();
				static GLuint text0 = DS::MTexture::GetPointer()->GetTexture("intro_text0");
				glTranslatef(-0.2, 0.35, 0);
				glBindTexture(GL_TEXTURE_2D, text0);
				Tools::DrawQuad(5.12, 0.64);
			glPopMatrix();
					// Text: Line1
			glPushMatrix();
				static GLuint text1 = DS::MTexture::GetPointer()->GetTexture("intro_text1");
				glBindTexture(GL_TEXTURE_2D, text1);
				glTranslatef(-0.2, -0.35, 0);
				Tools::DrawQuad(5.12, 0.64);
			glPopMatrix();
				
			glDisable(GL_TEXTURE_2D);
			glDisable(GL_BLEND);
	
			// Hide/Reveal text
			glColor3f(0, 0, 0);
			glPushMatrix();
				glTranslatef(-0.2, 0.35, 0);
					Tools::DrawQuad(-2.56 + line0_pos + 0.57, -0.32, 2.56, 0.32);
				glPopMatrix();

				glPushMatrix();			
					glTranslatef(-0.2, -0.35, 0);
					Tools::DrawQuad(-2.56 + line1_pos + 0.57, -0.32, 2.56, 0.32);
				glPopMatrix();		
				
			// White marker
			glPushMatrix();
				static float blink = 0;
				static float bcolor = 0;
				if(blink_active)
				{
					blink += 0.2*move;
					if(blink >= 1) {
						if(bcolor)
							bcolor = 0;
						else 
							bcolor = 1;
						blink = 0;
					}
					glColor3f(bcolor, bcolor, bcolor);
				}
				else {
					glColor3f(1, 1, 1);
					blink = 0;
					bcolor = 0;
				}
				
				if(!line)
					glTranslatef(-2.56 + 0.54 + line0_pos, 0.16, 0);
				else
					glTranslatef(-2.56 + 0.54 + line1_pos, -0.32-0.16, 0);
				Tools::DrawQuad(0.30, 0.10);
			glPopMatrix();		
/*			glPushMatrix();
				glEnable(GL_TEXTURE_2D);
				
				
				m_pWriter->Draw(move, 1-fadein, textstate);
				glDisable(GL_TEXTURE_2D);
			glPopMatrix();*/
		}
		

		
		// Whiteout ------------------------------------------------------------
		/*EVENT(END-250, END)
		{
			static float flash = 0;
			if(flash < 1)
				Change(flash, move, 4);
			else
				flash = 1;

			glClearColor(flash, flash, flash, 0);
		}*/
		
		if(time >= END )
			return END_SCENE;
		else
			return CONTINUE;
	}
}
