/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef SCENE_H
#define SCENE_H

#include "common.h"
#include "mmusic.h"
#include "mtexture.h"
#include "mmodel.h"
#include "mvideo.h"

namespace DS
{	
	class Scene {
	public:
		Scene();
		virtual ~Scene() {};
		virtual int DrawFrame(long time, float move) { return 0; };
		virtual int DrawFrame(long time, float move, LoadStates* pLoadStates) { return 0; };
		virtual int LoadScene()=0; // Run when demo loads
		virtual void EnterScene() {}; // Runs on scene switch before first frame
		virtual void ExitScene() {}; // Runs on scene switch after last frame
#ifdef DEBUG
		const char* GetIdentity() { return m_identity.c_str(); };
#endif
	protected:
		void Change(float &Value, float move, float ChangeInSecond);
		DS::MVideo* m_pMVideo;
		DS::MMusic* m_pMMusic;
		DS::MTexture* m_pMTexture;
		DS::MModel* m_pMModel;
#ifdef DEBUG
		std::string m_identity;
#endif
	};

	// Scene event shortcut
	#define EVENT(Start, Stop) if(time > Start && time < Stop)
	
	// Other scene shortcuts
	#define BIND_TEX(NAME) glBindTexture(GL_TEXTURE_2D, m_pMTexture->GetTexture(NAME))
	
	// Scene returncodes
	#define CONTINUE 0
	#define END_SCENE 1
	#define RUN_NEXT_SCENE 2
}

#endif
