/*  DS
 *  Copyright (C) Anders Asplund and Joakim Kolsjö 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "mvideo.h"

using namespace std;

namespace DS
{
	MVideo::MVideo()
	{
		m_pScreen = 0;
	}
		
	MVideo::~MVideo()
	{
	}
	
	void MVideo::Instance()
	{
		if(!m_pInstance)
			m_pInstance = new MVideo();
	}
	
	MVideo* MVideo::GetPointer()
	{
		return m_pInstance;
	}
	
	void MVideo::Init(int Width, int Height, int Bpp, bool Fullscreen, const char *Title)
	{
		m_Width = Width;
		m_Height = Height;
		m_Bpp = Bpp;
		m_Fullscreen = Fullscreen;
		m_Title = Title;
		m_pScreen = 0;
		
		OpenWindow();
	}
	
	void MVideo::Reset(int Width, int Height, bool Fullscreen)
	{
		m_Width = Width;
		m_Height = Height;
		m_Fullscreen = Fullscreen;		
		
		OpenWindow();
	}

	void MVideo::OpenWindow()
	{
		// Set video flags
		int flags = SDL_SWSURFACE;
		flags |= SDL_OPENGL;
		
		if(m_Fullscreen)
			flags |= SDL_FULLSCREEN;
				
		// Get screen pointer
		SDL_Surface* pScreenSurface;
		if(!(pScreenSurface = SDL_SetVideoMode(m_Width, m_Height, m_Bpp, flags)))
			throw domain_error(((string)"MVideo mode set failed: " + SDL_GetError()).c_str());
				
		// Delete old screen pointer if sutch exists
		if(m_pScreen)
			delete m_pScreen;
		
		// Save pointer
		m_pScreen = pScreenSurface;
		
		// Set window title
		SDL_WM_SetCaption(m_Title.c_str(), NULL);
		
		// Hide cursor
		SDL_ShowCursor(0);
	}
	
	void MVideo::Update()
	{
		SDL_GL_SwapBuffers();
	}
}
