/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef MMUSIC_H
#define MMUSIC_H

#include "common.h"
#include "SDL/SDL_mixer.h"

namespace DS
{	
	class MMusic
	{
	public:
		~MMusic();
		static void Instance(const char* pBaseDirectory);
		static MMusic* GetPointer();
		
		int Init(int samplerate, int volume, bool active);
		void Load();
		void Play(const char* pIdentity, bool loop);
		void Stop();
		void SetVolume(int volume);
		int GetVolume();
	protected:
		MMusic(const char* pBaseDirectory);
	private:
		//std::map <std::string, Mix_Music*> m_songs;
		//std::vector<std::string> m_songNames;
		Mix_Music* m_song;
		bool m_active;
		int m_volume;
		static MMusic *m_pInstance;
		std::string m_BaseDirectory;
	};	
}

#endif
