/*  DS
 *  Copyright (C) Anders Asplund and Joakim Kolsjö 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "mmusic.h"
#include "dirlist.h"

using namespace std;

namespace DS
{
	MMusic::MMusic(const char* pBaseDirectory)
	{
		m_BaseDirectory = pBaseDirectory;
		m_BaseDirectory += "/music";
		m_active = false;
		m_song = 0;
	}
	
	MMusic::~MMusic()
	{
		if(m_active)
		{					
		/*	if(m_songs.size() > 0)
			{			
				std::map <std::string, Mix_Music*>::iterator iter = m_songs.begin();
				while(iter != m_songs.end())
				{
					//Mix_FreeMusic(iter->second); // Segfaults
					++iter;
				}
			}*/
			SDL_CloseAudio();
		}
	}
	
	void MMusic::Instance(const char* pBaseDirectory)
	{
		if(!m_pInstance)
			m_pInstance = new MMusic(pBaseDirectory);
	}
	
	MMusic* MMusic::GetPointer()
	{
		return m_pInstance;
	}
	
	int MMusic::Init(int samplerate, int volume, bool active)
	{
		m_active = active;
		m_volume = volume;
		if(m_active)
		{
			if(Mix_OpenAudio(samplerate, MIX_DEFAULT_FORMAT, 2, 1024) == -1)
			{
				cout << "MMusic: Can't open audio: " << Mix_GetError() << endl;
				m_active = false;
				return 1;
			}
			Mix_VolumeMusic(m_volume);
		}
		return 0;
	}		

	void MMusic::Load()
	{	
	/*	if(m_active)
		{
			vector<string> songs = DS::DirectoryList::GetPointer()->GetFileList(m_BaseDirectory.c_str());
			for(int i = 0; i < (int)songs.size(); i++)
			{
				// Only xm for now
				if(songs[i].substr(songs[i].size()-2, 2) == "xm")
				{
					string identity = songs[i].substr(m_BaseDirectory.size()+1, songs[i].size() - m_BaseDirectory.size()-4);					
					Mix_Music* pMusic;
					
					pMusic = Mix_LoadMUS(songs[i].c_str());
						
					if(!pMusic) {
						cout << "MMusic: Can't load song (" << songs[i] << "):" << Mix_GetError() << endl;
						m_active = false;
					}

					m_songs[identity] = pMusic;
					m_songNames.push_back(identity);
				}
			}
		}*/
	}
	
	void MMusic::Play(const char* pIdentity, bool loop)
	{
		
		if(m_active)
		{
			if(m_song)
				Mix_FreeMusic(m_song);
			
			string file = m_BaseDirectory + "/" + pIdentity + ".xm";
			m_song = Mix_LoadMUS(file.c_str());
			
			if(-1 == Mix_PlayMusic(m_song, 1))
				cout << "MMusic: Can't play song: " << Mix_GetError() << endl;									
			
			/*if(!m_songs[pIdentity])
				cout << "MMusic: Can't play song \"" << pIdentity << "\", it does not exist." << endl;
			else {
				int state;
				if(loop)
					state = -1;
				else
					state = 1;
				

			}*/
		}
	}
	
	void MMusic::SetVolume(int volume)
	{
		m_volume = volume;
		if(m_active)
		{
			Mix_VolumeMusic(m_volume);
		}			
	}
	
	int MMusic::GetVolume()
	{
		return m_volume;
	}

	void MMusic::Stop()
	{
		Mix_HaltMusic();
		//Mix_RewindMusic();
	}	
	
}
