/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef MMODEL_H
#define MMODEL_H

#include "common.h"
#include "model.h"

namespace DS
{
	class MModel {
	public:
		~MModel();
		static void Instance(const char* pBaseDirectory);
		static MModel* GetPointer();
		int Load(float &state, bool &active);
		int LoadGLTextures();
		Model* GetModel(const char* pIdentity);
		std::vector<std::string> GetList();
		std::vector<std::string> GetList(const char* pHead);
	protected:
		MModel(const char* pBaseDirectory);
	private:
		int LoadSingle(const char* pIdentity);
		std::string m_BaseDirectory;
		std::map <std::string, Model*> m_models;
		std::vector<std::string> m_modelNames;
		static MModel* m_pInstance;
	};
}

#endif
