/*  DS
 *  Copyright (C) Anders Asplund and Joakim Kolsjö 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "mfont.h"

using namespace std;

namespace IO
{
#if 0
	TFont::TFont(const char* pFile, int Size)
	{
		m_pFont = TTF_OpenFont(pFile, Size);
		
		if(!m_pFont)
			throw domain_error((string)"TTF_OpenFont: " + TTF_GetError());
		
		m_FontColor.r = 255;
		m_FontColor.g = 255;
		m_FontColor.b = 255;
		m_pTarget = 0;
	}
	
	TFont::~TFont()
	{
		TTF_CloseFont(m_pFont);
	}
	
	void TFont::SetColor(int r, int g, int b)
	{
		m_FontColor.r = r;
		m_FontColor.g = g;
		m_FontColor.b = b;
	}
	
	void TFont::SetColor(SDL_Color* pColor)
	{
		m_FontColor.r = pColor->r;
		m_FontColor.g = pColor->g;
		m_FontColor.b = pColor->b;
	}
	
	void TFont::SetTarget(DS::Surface* pTarget)
	{
		m_pTarget = pTarget;
	}
	
	void TFont::Render(int x, int y, const char* pText)
	{
		if(!m_pTarget)
			throw domain_error("You have to specify a target surface for the font.");
		
		DS::Surface* pTemp = new DS::Surface(TTF_RenderText_Solid(m_pFont, pText, m_FontColor));		
		SDL_Rect DestRect;
		DestRect.x = x;
		DestRect.y = y;
		pTemp->Blit(m_pTarget, 0, &DestRect);
		delete pTemp;
	}
	
	DS::Surface* TFont::RenderNew(const char* pText)
	{		
		DS::Surface* pNew = new DS::Surface(TTF_RenderText_Solid(m_pFont, pText, m_FontColor));		
		return pNew;
	}
	
	Font::Font()
	{
		if(!TTF_WasInit() && TTF_Init() == -1)
			throw domain_error((string)"TTF_Init: " + TTF_GetError());
	}
	
	Font::~Font()
	{
		TTF_Quit();
		
		// Cleanup Font memory
		if(m_FontMap.size() > 0)
		{
			map<std::string, TFont*>::iterator Iter = m_FontMap.begin();
			while(Iter != m_FontMap.end())
			{
				delete Iter->second;
				++Iter;	
			}
			m_FontMap.clear();
		}
	}
	
	void Font::Instance()
	{
		if(!m_pInstance)
			m_pInstance = new Font();
	}
	
	Font* Font::GetPointer()
	{
		return m_pInstance;
	}
	
	void Font::LoadFont(const char* pFile, int Size)
	{
		TFont* pTemp = new TFont(pFile, Size);
		if(!pTemp)
			throw domain_error("Failed to load font!");

		string Filename = pFile;
		string Identity = Filename.substr(Filename.find_last_of("/")+1,
							Filename.find_last_of(".") - Filename.find_last_of("/")-1);
		
		// Save fonts with their size, like: "fontname@size".
		stringstream ss; ss << Size;
		Identity = Identity + "@" + ss.str();
		
		if(!m_FontMap[Identity])
			m_FontMap[Identity] = pTemp;
	}
	
	TFont* Font::GetFont(const char* pIdentity)
	{
		if(!m_FontMap[pIdentity])
			throw domain_error((string)"Font " + pIdentity + " is not loaded!");
		
		return m_FontMap[pIdentity];
	}
#endif
}
