/*  DS
 *  Copyright (C) Joakim Kolsjö 2004-2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */
 
#ifndef DIRLIST_H
#define DIRLIST_H

#include <string>
#include <vector>

namespace DS
{
	class DirectoryList {
	public:
		~DirectoryList();
		static void Instance(const char* pDataDirectory);
		static DirectoryList* GetPointer();
		void Update();
		std::vector<std::string> GetFileList();
		std::vector<std::string> GetFileList(const char* pHead);
	protected:
		DirectoryList(const char* pDataDirectory);
	private:
		void ParseDir(const char* pDirectory);
		std::vector<std::string> m_files;
		static DirectoryList* m_pInstance;
		std::string m_dataDirectory;
	};
}
#endif
