/*  DS
 *  Copyright (C) Anders Asplund and Joakim Kolsjö 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "dirlist.h"
#include "common.h"

#ifdef WIN32
	#include <windows.h>
#else
	#include <dirent.h>
#endif

using namespace std;

namespace DS
{
	DirectoryList::DirectoryList(const char* pDataDirectory)
	{
		ParseDir(pDataDirectory);
		m_dataDirectory = pDataDirectory;
	}
	
	DirectoryList::~DirectoryList()
	{
		m_files.clear();
	}
	
	void DirectoryList::Instance(const char* pDataDirectory)
	{
		if(!m_pInstance)
			m_pInstance = new DirectoryList(pDataDirectory);
	}
	
	DirectoryList* DirectoryList::GetPointer()
	{
		return m_pInstance;
	}
	
	void DirectoryList::Update()
	{
		m_files.clear();
		ParseDir(m_dataDirectory.c_str());
	}
	
	std::vector<std::string> DirectoryList::GetFileList()
	{
		return m_files;
	}

	std::vector<std::string> DirectoryList::GetFileList(const char* pHead)
	{
		// Get list of files that start with the contents of pHead.
		vector<string> outlist;
		string head = pHead;
		int size = head.size();
		if(size > 0)
		{
			for(int i = 0; i < (int)m_files.size(); i++)
			{
				if(m_files[i].substr(0, size) == head)
					outlist.push_back(m_files[i]);
			}
		}
		return outlist;
	}
	
#ifdef unix
	void DirectoryList::ParseDir(const char* pDirectory)
	{
		DIR *pDirent = opendir(pDirectory);
		rewinddir(pDirent);
		dirent *pDirItem;

		while((pDirItem = readdir(pDirent)))
		{
			string item = pDirItem->d_name;
			if(item != "." && item != "..")
			{
				// If directory, browse it
				DIR* pTempDir = opendir(((string) pDirectory + "/" + item).c_str());
				if(pTempDir) {
				//if(pDirItem->d_type == DT_DIR) // Does not work on some linux systems
					closedir(pTempDir);
					ParseDir(((string) pDirectory + "/" + item).c_str());
				}
				else // Else add file to list 
					m_files.push_back((string)pDirectory + "/" + item);
			}			
		}
		closedir(pDirent);
	}
#endif

#ifdef WIN32
	void DirectoryList::ParseDir(const char* pDirectory)
	{
		WIN32_FIND_DATA fileData;
		string str_dir = pDirectory;
		HANDLE directory = FindFirstFile((str_dir+(string)"/*").c_str(), &fileData);

		for(;;)
		{ 
			string item = fileData.cFileName;
			if(item != "." && item != "..")
			{
				// If directory, browse it
				if(fileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
					ParseDir(((string)pDirectory + "/" + item).c_str());
				else // Else add file to list
					m_files.push_back((string)pDirectory + "/" + item);
			}
			
			if(!FindNextFile(directory, &fileData))
				if(GetLastError() == ERROR_NO_MORE_FILES)
					break;
		} 

		FindClose(directory);
	}	
#endif
}
