#ifndef __SDL_H__
#define __SDL_H__

#include <SDL/SDL.h>

#define SDL_Init(x)               _SDL_Init(x)
#define SDL_Quit()                _SDL_Quit()
#define SDL_SetVideoMode(x,y,z,i) _SDL_SetVideoMode(x,y,z,i)
#define SDL_PollEvent(x)          _SDL_PollEvent(x)
#define SDL_GL_SwapBuffers()      _SDL_GL_SwapBuffers()
#define SDL_OpenAudio(x,y)        _SDL_OpenAudio(x,y)
#define SDL_PauseAudio(x)         _SDL_PauseAudio(x)
#define SDL_GetTicks()            _SDL_GetTicks()

extern int (*_SDL_Init)(Uint32 flags);
extern void (*_SDL_Quit)(void);
extern SDL_Surface *(*_SDL_SetVideoMode)(int width, int height, int bpp, Uint32 flags);
extern int (*_SDL_PollEvent)(SDL_Event *event);
extern void (*_SDL_GL_SwapBuffers)( void );
extern int (*_SDL_OpenAudio)(SDL_AudioSpec *desired, SDL_AudioSpec *obtained);
extern void (*_SDL_PauseAudio)(int pause_on);
extern Uint32 (*_SDL_GetTicks)( void );
void InitSDL(int w=320, int h=240, int bpp=32);

#endif
