#include <SDL/SDL.h>
#include <dlfcn.h>

void *libsdl;
SDL_Surface *screen;

int (*_SDL_Init)(Uint32 flags);
void (*_SDL_Quit)(void);
SDL_Surface *(*_SDL_SetVideoMode)(int width, int height, int bpp, Uint32 flags);
int (*_SDL_PollEvent)(SDL_Event *event);
void (*_SDL_GL_SwapBuffers)( void );
int (*_SDL_OpenAudio)(SDL_AudioSpec *desired, SDL_AudioSpec *obtained);
void (*_SDL_PauseAudio)(int pause_on);
void (*_SDL_GetTicks)( void );
//void (*_SDL_LockAudio)( void );
//void (*_SDL_UnlockAudio)( void );

void InitSDL(int w, int h, int bpp) {
  libsdl = dlopen("libSDL-1.2.so.0", RTLD_LAZY);
  (void*)_SDL_Init = dlsym(libsdl, "SDL_Init");
  (void*)_SDL_Quit = dlsym(libsdl, "SDL_Quit");
  (void*)_SDL_SetVideoMode = dlsym(libsdl, "SDL_SetVideoMode");
  (void*)_SDL_PollEvent  = dlsym(libsdl, "SDL_PollEvent");
  (void*)_SDL_GL_SwapBuffers  = dlsym(libsdl, "SDL_GL_SwapBuffers");
  (void*)_SDL_OpenAudio  = dlsym(libsdl, "SDL_OpenAudio");
  (void*)_SDL_PauseAudio  = dlsym(libsdl, "SDL_PauseAudio");
  (void*)_SDL_GetTicks  = dlsym(libsdl, "SDL_GetTicks");
  //(void*)_SDL_LockAudio = dlsym(libsdl, "SDL_LockAudio");
  //(void*)_SDL_UnlockAudio = dlsym(libsdl, "SDL_UnlockAudio");

  (*_SDL_Init)(SDL_INIT_EVERYTHING);
  screen = (*_SDL_SetVideoMode)(w, h, bpp, SDL_OPENGL|SDL_FULLSCREEN);
}
