#include "intro.h"
#include "sdl.h"
#include "gl.h"
SDL_Event event;

#define TWOPI 6.2831853071795862

int flash1=0;
int flash2=0;

float frameTime;
int lastTime;

void InitIntro() {
   int width = 640;
   int height = 480;

   glClearColor( 0, 0, 0, 0 );
   glViewport( 0, 0, width, height );
   glEnable(GL_DEPTH_TEST);
   glMatrixMode( GL_PROJECTION );
   glLoadIdentity( );
   glFrustum(-1.0, 1.0, -1.0, 1.0, 1.0, 100.0);
   lastTime = SDL_GetTicks();
}

void UpdateIntro() {
  static float rot=0.0f;
  while(SDL_PollEvent(&event)) {
    switch(event.type) {
      case SDL_KEYDOWN:
      case SDL_QUIT:
        Quit();
        return;
    }
  }
  int thisTime = SDL_GetTicks();
  frameTime = float(thisTime - lastTime)/1000;
  lastTime = thisTime;

  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glTranslatef(0.0f, 0.0f, -2.0f);

  if(flash1) {
   glTranslatef(-1.0f,0.0f,0.0f);
   glBegin( GL_QUADS );
    glColor3f( 1.0f, 1.0f, 0.0f );
    glVertex3f(-1.0f,-2.0f,  0.0f);
    glVertex3f(-1.0f, 2.0f,  0.0f);
    glColor3f( 0.0f, 1.0f, 1.0f );
    glVertex3f( 1.0f, 2.0f,  0.0f);
    glVertex3f( 1.0f,-2.0f,  0.0f);
   glEnd();
   glTranslatef(1.0f,0.0f,0.0f);
  }

  if(flash2) {
   glTranslatef(1.0f,0.0f,0.0f);
   glBegin( GL_QUADS );
    //glColor3f( 1.0f, 1.0f, 1.0f );
    glColor3f( 0.0f, 1.0f, 1.0f );
    glVertex3f(-1.0f,-2.0f,  0.0f);
    glVertex3f(-1.0f, 2.0f,  0.0f);
    glColor3f( 1.0f, 0.0f, 1.0f );
    glVertex3f( 1.0f, 2.0f,  0.0f);
    glVertex3f( 1.0f,-2.0f,  0.0f);
   glEnd();
   glTranslatef(-1.0f,0.0f,0.0f);
  }
/*
  float ang = TWOPI/50.0;
  glRotatef(rot, 0.0f, 0.0f, 1.0f);
  glBegin(GL_TRIANGLES);
   for(float rad=0;rad <= TWOPI;rad += ang*2) {
     glVertex3f( sinf(rad), cosf(rad), 0.0f);
     glVertex3f( sinf(rad+ang), cosf(rad+ang), 0.0f);
     glVertex3f( 0.0f, 0.0f, 0.0f);
   }
  glEnd();
*/
  glRotatef(rot, 1.0f, 0.0f, 0.0f);
  glRotatef(rot, 0.0f, 0.0f, 1.0f);
  rot+=frameTime*100.0f;
  for(int mandel=0;mandel<4;mandel++) {
    glRotatef(rot, 0.0f, 1.0f, 0.0f);
    glBegin( GL_TRIANGLES );
     glColor3f ( 1.0f, 1.0f, 1.0f );
     glVertex3f( 0.0f, 0.0f, 0.0f );
     glColor3f ( 0.0f, 1.0f, 1.0f );
     glVertex3f( 2.0f, 0.0f, 0.0f );
     glColor3f ( 0.0f, 0.0f, 1.0f );
     glVertex3f( 0.0f, 2.0f, 0.0f );
    glEnd();
    glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
  }
  SDL_GL_SwapBuffers();
}

void Quit() {
  running = false;
  SDL_Quit();
}
bool running=true;

