#ifndef __GL_H__
#define __GL_H__

#include <GL/gl.h>
#include <dlfcn.h>

#define glClearColor(x,y,z,i)  (*_glClearColor)(x,y,z,i)
#define glClear(x)             (*_glClear)(x)
#define glViewport(x,y,z,i)    (*_glViewport)(x,y,z,i)
#define glMatrixMode(x)        (*_glMatrixMode)(x)
#define glLoadIdentity()       (*_glLoadIdentity)()
#define glFrustum(x,y,z,i,j,k) (*_glFrustum)(x,y,z,i,j,k)
#define glBegin(x)             (*_glBegin)(x)
#define glEnd()                (*_glEnd)()
#define glTranslatef(x,y,z)    (*_glTranslatef)(x,y,z)
#define glRotatef(x,y,z,i)     (*_glRotatef)(x,y,z,i)
#define glColor3f(x,y,z)       (*_glColor3f)(x,y,z)
#define glVertex3f(x,y,z)      (*_glVertex3f)(x,y,z)
#define glEnable(x)            (*_glEnable)(x)

extern void (*_glClearColor)(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
extern void (*_glClear)( GLbitfield mask );
extern void (*_glViewport)(GLint x, GLint y, GLsizei width, GLsizei height);
extern void (*_glMatrixMode)( GLenum mode );
extern void (*_glLoadIdentity)( void );
extern void (*_glFrustum)( GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble near_val, GLdouble far_val );
extern void (*_glBegin)( GLenum mode );
extern void (*_glEnd)( void );
extern void (*_glTranslatef)( GLfloat x, GLfloat y, GLfloat z );
extern void (*_glRotatef)( GLfloat angle, GLfloat x, GLfloat y, GLfloat z );
extern void (*_glColor3f)( GLfloat red, GLfloat green, GLfloat blue );
extern void (*_glVertex3f)( GLfloat x, GLfloat y, GLfloat z );
extern void (*_glEnable)( GLenum cap);
void InitGL();

#endif //__GL_H__
