#include "gl.h"

#include <dlfcn.h>

void (*_glClearColor)(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
void (*_glClear)( GLbitfield mask );
void (*_glViewport)(GLint x, GLint y, GLsizei width, GLsizei height);
void (*_glMatrixMode)( GLenum mode );
void (*_glLoadIdentity)( void );
void (*_glFrustum)( GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble near_val, GLdouble far_val );
void (*_glBegin)( GLenum mode );
void (*_glEnd)( void );
void (*_glTranslatef)( GLfloat x, GLfloat y, GLfloat z );
void (*_glRotatef)( GLfloat angle, GLfloat x, GLfloat y, GLfloat z );
void (*_glColor3f)( GLfloat red, GLfloat green, GLfloat blue );
void (*_glVertex3f)( GLfloat x, GLfloat y, GLfloat z );
void (*_glEnable)( GLenum cap );

void* libgl;
void InitGL() {
  libgl=dlopen("libGL.so", RTLD_LAZY);
  (void*)_glClearColor   = dlsym(libgl,"glClearColor");
  (void*)_glClear        = dlsym(libgl,"glClear");
  (void*)_glViewport     = dlsym(libgl,"glViewport");
  (void*)_glMatrixMode   = dlsym(libgl,"glMatrixMode");
  (void*)_glLoadIdentity = dlsym(libgl,"glLoadIdentity");
  (void*)_glFrustum      = dlsym(libgl,"glFrustum");
  (void*)_glBegin        = dlsym(libgl,"glBegin");
  (void*)_glEnd          = dlsym(libgl,"glEnd");
  (void*)_glTranslatef   = dlsym(libgl,"glTranslatef");
  (void*)_glRotatef      = dlsym(libgl,"glRotatef");
  (void*)_glColor3f      = dlsym(libgl,"glColor3f");
  (void*)_glVertex3f     = dlsym(libgl,"glVertex3f");
  (void*)_glEnable       = dlsym(libgl,"glEnable");
}
