#include "intro.h"
#include "sdl.h"
#include <iostream>
using namespace std;

int start;
bool loaded=false;
char song1[] = { 34, 00, 34, 00, 34, 00, 38, 00,
                36, 00, 36, 00, 36, 00, 39, 00,
                38, 00, 38, 00, 36, 00, 36, 00,
                34, 34, 34, 34, 00, 00, 00, 00,
                38, 00, 38, 00, 38, 00, 38, 00,
                41, 41, 41, 00, 39, 39, 39, 00,
                36, 00, 36, 00, 36, 00, 36, 00,
                39, 39, 39, 00, 38, 38, 38, 00,
                34, 00, 34, 00, 34, 00, 38, 00,
                36, 00, 36, 00, 36, 00, 39, 00,
                38, 00, 38, 00, 36, 00, 36, 00,
                34, 34, 34, 34, 00, 00, 00, 00,
                -1};

char song2[] = {36, 00, 36, 00, 34, 34, 34, 34,
                00, 00, 00, 00, 38, 00, 38, 00,
                38, 00, 38, 00, 41, 41, 41, 00,
                39, 39, 39, 00, 36, 00, 36, 00,
                36, 00, 36, 00, 39, 39, 39, 00,
                38, 38, 38, 00, 34, 00, 34, 00,
                34, 00, 38, 00, 36, 00, 36, 00,
                36, 00, 39, 00, 38, 00, 38, 00,
                36, 00, 36, 00, 34, 34, 34, 34,
                00, 00, 00, 00, 34, 00, 34, 00,
                34, 00, 38, 00, 36, 00, 36, 00,
                36, 00, 39, 00, 38, 00, 38, 00,
                -1};
int songPos = 0;
unsigned int sp = 0;

#define C 65.406391325149656
#define FACT 1.0594630943592953
#define TWOPI 6.2831853071795862

float *NoteMap;
void InitNotes(int octs=10) {
    float note = C;
    NoteMap = new float[octs*12];
    for(int i=0;i<12*octs;i++) {
      NoteMap[i] = note;
      note *= FACT;
    }
}

struct Channel {
  float pos;
  float speed;
  char *song;
};

void InitChannel(Channel &c, char *s) {
  c.pos = 0;
  c.speed = NoteMap[s[0]]*(TWOPI/44100.0);
  c.song = s;
}

inline short getSample1(Channel &c) {
  if(c.song[songPos] != 0) {
    c.speed -= 0.000002;
    c.pos += c.speed;
    while(c.pos > TWOPI) c.pos -= TWOPI;
  }
  return (Uint16)(sinf(c.pos)*16000.0f);
}

inline short getSample2(Channel &c) {
  if(c.song[songPos] != 0) {
    c.speed += 0.000001;
    c.pos += c.speed;
    while(c.pos > TWOPI) c.pos -= TWOPI;
  }
  return (Uint16)(sinf(c.pos)*16000.0f);
}

void updateChannel(Channel &c) {
  if(c.song[songPos])
    c.speed = NoteMap[c.song[songPos]]*(TWOPI/44100.0);
}

Channel cs[2];

void audio_cb(void *udata, Uint8 *stream, int len) {
  Uint16 *s = (Uint16*)stream;
  static unsigned long int p=0;
  signed short int samp=0;

  for(int i=0;i<len/2;i+=2) {
    s[i] = getSample1(cs[0]);
    s[i+1] = getSample2(cs[1]);
    p++;
    if(p > 11025) {
      songPos++;
      if(song1[songPos] == -1) {
        Quit();
        return;
      } else {
        updateChannel(cs[0]);
        updateChannel(cs[1]);
      }
      p=0;
    }
  }
  sp += len;
  if(!loaded) {
    loaded=true;
    start=SDL_GetTicks();
  }
}

void InitAudio() {
  InitNotes();
  SDL_AudioSpec dspec, ospec;
  InitChannel(cs[0], song1);
  InitChannel(cs[1], song2);
  dspec.freq = 44100;
  dspec.format = AUDIO_S16LSB;
  dspec.channels = 2;
  dspec.samples = 1024*8;
  dspec.callback = audio_cb;
  dspec.userdata = NULL;

  SDL_OpenAudio( &dspec, &ospec );
  SDL_PauseAudio(0);
  while(!loaded) {}
}
