/*
 
 * File    : xistDraw.cpp
 * Version : 0.4
 * Grp     : xist
 * Code    : ziL (peter@codeseven.org)
 * Desc    : Draw stuff onto a SDL surface 
 
 */ 
 
#include "xistdraw.h"

void xistDraw::Pixel(SDL_Surface *screen, int x, int y, Uint8 R, Uint8 G, Uint8 B, int wx, int wy) {
  
  if( SDL_MUSTLOCK( screen ) ) SDL_LockSurface( screen );
  
  if(!(x < 1 || x > wx || y < 1 || y > wy)) {
    
    if(R<1) R=0;
    if(G<1) G=0;
    if(B<1) B=0;
    
    Uint32 color = SDL_MapRGB(screen->format, R, G, B);
  
    switch (screen->format->BytesPerPixel) {
    
    case 1: // Assuming 8-bpp
    {	
      Uint8 *bufp;
      bufp = (Uint8 *)screen->pixels + y*screen->pitch + x;
      *bufp = color;
    }
    break;
  
    case 2: // Probably 15-bpp or 16-bpp
    {  	
      Uint16 *bufp;
      bufp = (Uint16 *)screen->pixels + y*screen->pitch/2 + x;
      *bufp = color;
    }
    break;
  
    case 3: // Slow 24-bpp mode, usually not used
    {	
      Uint8 *bufp;
      bufp = (Uint8 *)screen->pixels + y*screen->pitch + x * 3;
 
      if(SDL_BYTEORDER == SDL_LIL_ENDIAN) {	
	bufp[0] = color;
	bufp[1] = color >> 8;
	bufp[2] = color >> 16;
      } else {
	bufp[2] = color;
	bufp[1] = color >> 8;
	bufp[0] = color >> 16;
      } 
    }
    break;  
  
    case 4: // Probably 32-bpp
    {	
      Uint32 *bufp;
      bufp = (Uint32 *)screen->pixels + y*screen->pitch/4 + x;
      *bufp = color;
    } 
    break;
    }
  }
  
  if( SDL_MUSTLOCK( screen ) ) SDL_UnlockSurface( screen );
  
}

void xistDraw::Number(SDL_Surface *screen, int x, int y, Uint8 R, Uint8 G, Uint8 B, int wx, int wy, int num) {
 
  bool n[9][6][6];
  
  // ****   
  // *  *
  // *  *
  // *  *
  // *  *
  // ****
  
  n[0][1][0] = 1;
  n[0][1][1] = 1;
  n[0][1][2] = 1;
  n[0][1][3] = 1;
  n[0][1][4] = 1;
  n[0][1][5] = 1;
  
  n[0][4][0] = 1;
  n[0][4][1] = 1;
  n[0][4][2] = 1;
  n[0][4][3] = 1;
  n[0][4][4] = 1;
  n[0][4][5] = 1;
  
  n[0][2][0] = 1;
  n[0][3][0] = 1;
  
  n[0][2][5] = 1;
  n[0][3][5] = 1;
  
  
  //   *
  //  **
  //   *
  //   *
  //   *
  //  ***
  
  n[1][3][0] = 1;
  
  n[1][2][1] = 1;
  n[1][3][1] = 1;
  
  n[1][3][2] = 1;
  n[1][3][3] = 1;
  n[1][3][4] = 1;
  
  n[1][2][5] = 1;
  n[1][3][5] = 1;
  n[1][4][5] = 1;
  
  
  //  ***  
  // *   *
  //    *
  //   * 
  //  *
  // *****
  
  
  n[2][2][0] = 1;
  n[2][3][0] = 1;
  n[2][4][0] = 1;
  
  n[2][1][1] = 1;
  n[2][5][1] = 1;
  
  n[2][4][2] = 1;
  
  n[2][3][3] = 1;
  
  n[2][2][4] = 1;
  
  n[2][1][5] = 1;
  n[2][2][5] = 1;
  n[2][3][5] = 1;
  n[2][4][5] = 1;
  n[2][5][5] = 1;
  
  
  // *****
  //     *
  //   **
  //     *
  //     *
  // ****
  
  n[3][1][0] = 1;
  n[3][2][0] = 1;
  n[3][3][0] = 1;
  n[3][4][0] = 1;
  n[3][5][0] = 1;
  
  n[3][5][1] = 1;
  
  n[3][3][2] = 1;
  n[3][4][2] = 1;
  
  n[3][5][3] = 1;
  n[3][5][4] = 1;
  
  n[3][1][5] = 1;
  n[3][2][5] = 1;
  n[3][3][5] = 1;
  n[3][4][5] = 1;
    
    
    
  for(int n1=0;n1<6;n1++) {
    for(int n2=0;n2<6;n2++) {
      if(n[num][n2][n1] == 1)
       Pixel(screen, x+n2, y+n1, R, G, B,wx,wy);
      else
       Pixel(screen, x+n2, y+n1, 0, 0, 0,wx,wy);
    }
    
  }
  
}

void xistDraw::Image(SDL_Surface *screen, SDL_Surface *img, int x, int y) {
  SDL_Rect dest;
  dest.x = x;
  dest.y = y;
  SDL_BlitSurface(img, NULL, screen, &dest);
}

void xistDraw::Image(SDL_Surface *screen, SDL_Surface *img, int x, int y, int w, int h, int x2, int y2)
{
  SDL_Rect dest;
  dest.x = x;
  dest.y = y;
  SDL_Rect dest2;
  dest2.x = x2;
  dest2.y = y2;
  dest2.w = w;
  dest2.h = h;
  SDL_BlitSurface(img, &dest2, screen, &dest);
}
